/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.tribble.index.IndexCreator;
import htsjdk.tribble.index.tabix.StreamBasedTabixIndexCreator;
import htsjdk.tribble.index.tabix.TabixFormat;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.impl.formats.bgzf.TerminatorlessBlockCompressedOutputStream;

public class HeaderlessVcfOutputFormat
extends FileOutputFormat<Void, VariantContext> {
    private static VCFHeader header;
    private static boolean blockCompress;
    private static boolean writeTbiFile;

    public static void setHeader(VCFHeader header) {
        HeaderlessVcfOutputFormat.header = header;
    }

    public static void setBlockCompress(boolean blockCompress) {
        HeaderlessVcfOutputFormat.blockCompress = blockCompress;
    }

    public static void setWriteTbiFile(boolean writeTbiFile) {
        HeaderlessVcfOutputFormat.writeTbiFile = writeTbiFile;
    }

    public RecordWriter<Void, VariantContext> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException {
        Path file = this.getDefaultWorkFile(taskAttemptContext, "");
        Path tbiFile = writeTbiFile ? new Path(file.getParent(), "." + file.getName() + TabixIndexWriteOption.getIndexExtension()) : null;
        return new VcfRecordWriter(taskAttemptContext.getConfiguration(), file, header, blockCompress, tbiFile);
    }

    static class VcfRecordWriter
    extends RecordWriter<Void, VariantContext> {
        private final VariantContextWriter variantContextWriter;

        VcfRecordWriter(Configuration conf, Path file, VCFHeader header, boolean blockCompress, Path tbiFile) throws IOException {
            StreamBasedTabixIndexCreator tabixIndexCreator;
            if (!blockCompress && tbiFile != null) {
                throw new IllegalArgumentException("Cannot create tabix index for file that is not block compressed.");
            }
            FSDataOutputStream out = file.getFileSystem(conf).create(file);
            if (tbiFile == null) {
                tabixIndexCreator = null;
            } else {
                FSDataOutputStream tbiOut = file.getFileSystem(conf).create(tbiFile);
                tabixIndexCreator = new StreamBasedTabixIndexCreator(header.getSequenceDictionary(), TabixFormat.VCF, (OutputStream)tbiOut);
            }
            this.variantContextWriter = new VariantContextWriterBuilder().setOutputStream((OutputStream)((Object)(blockCompress ? new TerminatorlessBlockCompressedOutputStream((OutputStream)out) : out))).setReferenceDictionary(header.getSequenceDictionary()).setIndexCreator((IndexCreator)tabixIndexCreator).modifyOption(Options.INDEX_ON_THE_FLY, tbiFile != null).unsetOption(Options.DO_NOT_WRITE_GENOTYPES).unsetOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER).unsetOption(Options.WRITE_FULL_FORMAT_FIELD).build();
            this.variantContextWriter.setHeader(header);
        }

        public void write(Void ignore, VariantContext variantContext) {
            this.variantContextWriter.add(variantContext);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException {
            this.variantContextWriter.close();
        }
    }
}

