/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import org.disq_bio.disq.FileCardinalityWriteOption;
import org.disq_bio.disq.VariantsFormatWriteOption;

public enum VcfFormat {
    VCF(".vcf", ".idx", false),
    VCF_BGZ(".vcf.bgz", ".tbi", true),
    VCF_GZ(".vcf.gz", ".tbi", true);

    private String extension;
    private String indexExtension;
    private boolean compressed;

    private VcfFormat(String extension, String indexExtension, boolean compressed) {
        this.extension = extension;
        this.indexExtension = indexExtension;
        this.compressed = compressed;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getIndexExtension() {
        return this.indexExtension;
    }

    public boolean fileMatches(String path) {
        return path.endsWith(this.extension);
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public VariantsFormatWriteOption toFormatWriteOption() {
        return VariantsFormatWriteOption.valueOf(this.name());
    }

    public static VcfFormat fromFormatWriteOption(VariantsFormatWriteOption formatWriteOption) {
        return VcfFormat.valueOf(formatWriteOption.name());
    }

    public static VcfFormat fromExtension(String extension) {
        for (VcfFormat format : VcfFormat.values()) {
            if (!extension.equals(format.extension)) continue;
            return format;
        }
        return null;
    }

    public static VcfFormat fromPath(String path) {
        for (VcfFormat format : VcfFormat.values()) {
            if (!path.endsWith(format.extension)) continue;
            return format;
        }
        return null;
    }

    public static FileCardinalityWriteOption fileCardinalityWriteOptionFromPath(String path) {
        return VcfFormat.fromPath(path) == null ? FileCardinalityWriteOption.MULTIPLE : FileCardinalityWriteOption.SINGLE;
    }

    public static VariantsFormatWriteOption formatWriteOptionFromPath(String path) {
        VcfFormat vcfFormat = VcfFormat.fromPath(path);
        return vcfFormat == null ? null : vcfFormat.toFormatWriteOption();
    }
}

