/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.PathChunk;
import org.disq_bio.disq.impl.file.PathSplitSource;
import org.disq_bio.disq.impl.formats.SerializableHadoopConfiguration;
import org.disq_bio.disq.impl.formats.bam.BamRecordGuesser;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockGuesser;
import org.disq_bio.disq.impl.formats.bgzf.BgzfBlockSource;
import org.disq_bio.disq.impl.formats.sam.AbstractBinarySamSource;
import org.disq_bio.disq.impl.formats.sam.SamFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BamSource
extends AbstractBinarySamSource
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BamSource.class);
    private static final int MAX_READ_SIZE = 10000000;
    private final BgzfBlockSource bgzfBlockSource;
    private final PathSplitSource pathSplitSource;

    public BamSource(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
        this.bgzfBlockSource = new BgzfBlockSource(fileSystemWrapper);
        this.pathSplitSource = new PathSplitSource(fileSystemWrapper);
    }

    @Override
    public SamFormat getSamFormat() {
        return SamFormat.BAM;
    }

    @Override
    protected JavaRDD<PathChunk> getPathChunks(JavaSparkContext jsc, String path, int splitSize, ValidationStringency stringency, String referenceSourcePath) throws IOException {
        String sbiPath = path + ".sbi";
        if (this.fileSystemWrapper.exists(jsc.hadoopConfiguration(), sbiPath)) {
            logger.debug("Using SBI file {} for finding splits", (Object)sbiPath);
            try (SeekableStream sbiStream = this.fileSystemWrapper.open(jsc.hadoopConfiguration(), sbiPath);){
                SBIIndex sbiIndex = SBIIndex.load((InputStream)sbiStream);
                Broadcast sbiIndexBroadcast = jsc.broadcast((Object)sbiIndex);
                JavaRDD javaRDD = this.pathSplitSource.getPathSplits(jsc, path, splitSize).flatMap((FlatMapFunction & Serializable)pathSplit -> {
                    SBIIndex index = (SBIIndex)sbiIndexBroadcast.getValue();
                    Chunk chunk = index.getChunk(pathSplit.getStart(), pathSplit.getEnd());
                    if (chunk == null) {
                        return Collections.emptyIterator();
                    }
                    PathChunk pathChunk = new PathChunk(path, chunk);
                    logger.debug("PathChunk: {}", (Object)pathChunk);
                    return Collections.singleton(pathChunk).iterator();
                });
                return javaRDD;
            }
        }
        logger.debug("Using guessing for finding splits");
        SerializableHadoopConfiguration confSer = new SerializableHadoopConfiguration(jsc.hadoopConfiguration());
        return this.bgzfBlockSource.getBgzfBlocks(jsc, path, splitSize).mapPartitionsWithIndex((Function2 & Serializable)(partitionIndex, bgzfBlocks) -> {
            Configuration conf = confSer.getConf();
            PathChunk pathChunk = this.getFirstReadInPartition(conf, (Iterator<BgzfBlockGuesser.BgzfBlock>)bgzfBlocks, stringency, referenceSourcePath);
            logger.debug("PathChunk for partition {}: {}", partitionIndex, (Object)pathChunk);
            if (pathChunk == null) {
                return Collections.emptyIterator();
            }
            return Collections.singleton(pathChunk).iterator();
        }, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Locatable> PathChunk getFirstReadInPartition(Configuration conf, Iterator<BgzfBlockGuesser.BgzfBlock> bgzfBlocks, ValidationStringency stringency, String referenceSourcePath) throws IOException {
        try (BamRecordGuesser bamRecordGuesser = null;){
            String partitionPath = null;
            int index = 0;
            while (bgzfBlocks.hasNext()) {
                BgzfBlockGuesser.BgzfBlock block = bgzfBlocks.next();
                if (partitionPath == null) {
                    partitionPath = block.path;
                    try (SamReader samReader = this.createSamReader(conf, partitionPath, stringency, referenceSourcePath);){
                        SAMFileHeader header = samReader.getFileHeader();
                        bamRecordGuesser = this.getBamRecordGuesser(conf, partitionPath, header);
                    }
                }
                for (int up = 0; up < block.uSize; ++up) {
                    if (++index > 10000000) {
                        PathChunk pathChunk = null;
                        return pathChunk;
                    }
                    long vPos = BlockCompressedFilePointerUtil.makeFilePointer((long)block.pos, (int)up);
                    long vEnd = BlockCompressedFilePointerUtil.makeFilePointer((long)block.end);
                    if (!bamRecordGuesser.checkRecordStart(vPos)) continue;
                    block.end();
                    PathChunk pathChunk = new PathChunk(partitionPath, new Chunk(vPos, vEnd));
                    return pathChunk;
                }
            }
        }
        return null;
    }

    private BamRecordGuesser getBamRecordGuesser(Configuration conf, String path, SAMFileHeader header) throws IOException {
        SeekableStream ss = this.fileSystemWrapper.open(conf, path);
        return new BamRecordGuesser(ss, header.getSequenceDictionary().size(), header);
    }

    private BAMFileReader getUnderlyingBamFileReader(SamReader samReader) {
        BAMFileReader bamFileReader = (BAMFileReader)((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader).underlyingReader();
        if (bamFileReader.hasIndex()) {
            bamFileReader.getIndex();
        }
        return bamFileReader;
    }

    @Override
    protected CloseableIterator<SAMRecord> getIterator(SamReader samReader, SAMFileSpan chunks) {
        return this.getUnderlyingBamFileReader(samReader).getIterator(chunks);
    }

    @Override
    protected CloseableIterator<SAMRecord> createIndexIterator(SamReader samReader, QueryInterval[] intervals, boolean contained, long[] filePointers) {
        return this.getUnderlyingBamFileReader(samReader).createIndexIterator(intervals, contained, filePointers);
    }
}

