/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.tribble;

import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.Locatable;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.Index;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class TribbleIndexIntervalFilteringTextInputFormat
extends TextInputFormat {
    private static Index index;
    private static List<? extends Locatable> intervals;

    public static void setIndex(Index index) {
        TribbleIndexIntervalFilteringTextInputFormat.index = index;
    }

    public static void setIntervals(List<? extends Locatable> intervals) {
        TribbleIndexIntervalFilteringTextInputFormat.intervals = intervals;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List splits = super.getSplits(job);
        ArrayList<InputSplit> filteredSplits = new ArrayList<InputSplit>();
        ArrayList blocks = new ArrayList();
        for (Locatable locatable : intervals) {
            String contig = locatable.getContig();
            int intervalStart = locatable.getStart();
            int intervalEnd = locatable.getEnd();
            blocks.addAll(index.getBlocks(contig, intervalStart, intervalEnd));
        }
        block1: for (InputSplit inputSplit : splits) {
            if (!(inputSplit instanceof FileSplit)) {
                filteredSplits.add(inputSplit);
                continue;
            }
            FileSplit fileSplit = (FileSplit)inputSplit;
            long virtualSplitStart = BlockCompressedFilePointerUtil.makeFilePointer((long)fileSplit.getStart());
            long virtualSplitEnd = BlockCompressedFilePointerUtil.makeFilePointer((long)(fileSplit.getStart() + fileSplit.getLength()));
            for (Block block : blocks) {
                long blockEnd;
                long blockStart = block.getStartPosition();
                if (!TribbleIndexIntervalFilteringTextInputFormat.overlaps(virtualSplitStart, virtualSplitEnd, blockStart, blockEnd = block.getEndPosition())) continue;
                filteredSplits.add(inputSplit);
                continue block1;
            }
        }
        return filteredSplits;
    }

    private static boolean overlaps(long start, long end, long start2, long end2) {
        return start2 >= start && start2 <= end || end2 >= start && end2 <= end || start >= start2 && end <= end2;
    }
}

