/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq;

import htsjdk.samtools.util.Locatable;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.disq_bio.disq.FileCardinalityWriteOption;
import org.disq_bio.disq.HtsjdkVariantsRdd;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.TempPartsDirectoryWriteOption;
import org.disq_bio.disq.VariantsFormatWriteOption;
import org.disq_bio.disq.WriteOption;
import org.disq_bio.disq.impl.formats.vcf.VcfFormat;
import org.disq_bio.disq.impl.formats.vcf.VcfSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtsjdkVariantsRddStorage {
    private static final Logger logger = LoggerFactory.getLogger(HtsjdkVariantsRddStorage.class);
    private JavaSparkContext sparkContext;
    private int splitSize;

    public static HtsjdkVariantsRddStorage makeDefault(JavaSparkContext sparkContext) {
        return new HtsjdkVariantsRddStorage(sparkContext);
    }

    private HtsjdkVariantsRddStorage(JavaSparkContext sparkContext) {
        this.sparkContext = sparkContext;
    }

    public HtsjdkVariantsRddStorage splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public HtsjdkVariantsRdd read(String path) throws IOException {
        return this.read(path, null);
    }

    public <T extends Locatable> HtsjdkVariantsRdd read(String path, List<T> intervals) throws IOException {
        VcfSource vcfSource = new VcfSource();
        VCFHeader header = vcfSource.getFileHeader(this.sparkContext, path);
        JavaRDD<VariantContext> variants = vcfSource.getVariants(this.sparkContext, path, this.splitSize, intervals);
        return new HtsjdkVariantsRdd(header, variants);
    }

    public void write(HtsjdkVariantsRdd htsjdkVariantsRdd, String path, WriteOption ... writeOptions) throws IOException {
        VariantsFormatWriteOption formatWriteOption = null;
        FileCardinalityWriteOption fileCardinalityWriteOption = null;
        TempPartsDirectoryWriteOption tempPartsDirectoryWriteOption = null;
        ArrayList<String> indexesToEnable = new ArrayList<String>();
        for (WriteOption writeOption : writeOptions) {
            if (writeOption instanceof VariantsFormatWriteOption) {
                formatWriteOption = (VariantsFormatWriteOption)writeOption;
                continue;
            }
            if (writeOption instanceof FileCardinalityWriteOption) {
                fileCardinalityWriteOption = (FileCardinalityWriteOption)writeOption;
                continue;
            }
            if (writeOption instanceof TempPartsDirectoryWriteOption) {
                tempPartsDirectoryWriteOption = (TempPartsDirectoryWriteOption)writeOption;
                continue;
            }
            if (writeOption instanceof TabixIndexWriteOption && writeOption == TabixIndexWriteOption.ENABLE) {
                indexesToEnable.add(TabixIndexWriteOption.getIndexExtension());
                continue;
            }
            logger.warn("Unrecognized write option: {}", (Object)writeOption);
        }
        if (formatWriteOption == null) {
            formatWriteOption = VcfFormat.formatWriteOptionFromPath(path);
        }
        if (formatWriteOption == null) {
            throw new IllegalArgumentException("Path does not end in VCF extension, and format not specified.");
        }
        if (fileCardinalityWriteOption == null) {
            fileCardinalityWriteOption = VcfFormat.fileCardinalityWriteOptionFromPath(path);
        }
        String tempPartsDirectory = null;
        if (tempPartsDirectoryWriteOption != null) {
            tempPartsDirectory = tempPartsDirectoryWriteOption.getTempPartsDirectory();
        } else if (fileCardinalityWriteOption == FileCardinalityWriteOption.SINGLE) {
            tempPartsDirectory = path + ".parts";
        }
        fileCardinalityWriteOption.getAbstractVcfSink(formatWriteOption).save(this.sparkContext, htsjdkVariantsRdd.getHeader(), htsjdkVariantsRdd.getVariants(), path, tempPartsDirectory, indexesToEnable);
    }
}

