/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.CRAIIndexMerger;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.CraiWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.IndexFileMerger;

public class CraiMerger
extends IndexFileMerger<CRAIIndex, SAMFileHeader> {
    public CraiMerger(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
    }

    @Override
    protected String getIndexExtension() {
        return CraiWriteOption.getIndexExtension();
    }

    @Override
    protected IndexMerger<CRAIIndex> newIndexMerger(OutputStream out, long headerLength) throws IOException {
        return new CRAIIndexMerger(out, headerLength);
    }

    @Override
    protected CRAIIndex readIndex(Configuration conf, String file, SAMFileHeader header) throws IOException {
        CRAIIndex index;
        try (SeekableStream in = this.fileSystemWrapper.open(conf, file);){
            index = CRAMCRAIIndexer.readIndex((InputStream)in);
        }
        this.fileSystemWrapper.delete(conf, file);
        return index;
    }
}

