/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.disq_bio.disq.impl.file.FileSplitInputFormat;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.PathSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PathSplitSource
implements Serializable {
    private static final int DEFAULT_NIO_SPLIT_SIZE = 0x8000000;
    private static final Logger logger = LoggerFactory.getLogger(PathSplitSource.class);
    private final FileSystemWrapper fileSystemWrapper;

    public PathSplitSource(FileSystemWrapper fileSystemWrapper) {
        this.fileSystemWrapper = fileSystemWrapper;
    }

    public JavaRDD<PathSplit> getPathSplits(JavaSparkContext jsc, String path, int splitSize) throws IOException {
        if (this.fileSystemWrapper.usesNio()) {
            long actualSplitSize = splitSize <= 0 ? 0x8000000L : (long)splitSize;
            long len = this.fileSystemWrapper.getFileLength(null, path);
            int numSplits = (int)Math.ceil((double)len / (double)actualSplitSize);
            List range = LongStream.range(0L, numSplits).boxed().collect(Collectors.toList());
            return jsc.parallelize(range, numSplits).map((Function & Serializable)idx -> {
                long splitStart = idx * actualSplitSize;
                long splitEnd = splitStart + actualSplitSize > len ? len : splitStart + actualSplitSize;
                PathSplit pathSplit = new PathSplit(path, splitStart, splitEnd);
                logger.debug("PathSplit for partition {}: {}", idx, (Object)pathSplit);
                return pathSplit;
            });
        }
        Configuration conf = jsc.hadoopConfiguration();
        if (splitSize > 0) {
            conf.setInt("mapreduce.input.fileinputformat.split.maxsize", splitSize);
        }
        return jsc.newAPIHadoopFile(path, FileSplitInputFormat.class, Void.class, FileSplit.class, conf).mapPartitionsWithIndex((Function2 & Serializable)(idx, it) -> {
            Tuple2 t2 = (Tuple2)it.next();
            FileSplit fileSplit = (FileSplit)t2._2();
            PathSplit pathSplit = new PathSplit(fileSplit.getPath().toString(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength());
            logger.debug("PathSplit for partition {}: {}", idx, (Object)pathSplit);
            return Collections.singleton(pathSplit).iterator();
        }, true);
    }
}

