/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SBIIndex;
import htsjdk.samtools.SBIIndexMerger;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.SbiWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.IndexFileMerger;

public class SbiMerger
extends IndexFileMerger<SBIIndex, SAMFileHeader> {
    public SbiMerger(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
    }

    @Override
    protected String getIndexExtension() {
        return SbiWriteOption.getIndexExtension();
    }

    @Override
    protected IndexMerger<SBIIndex> newIndexMerger(OutputStream out, long headerLength) {
        return new SBIIndexMerger(out, headerLength);
    }

    @Override
    protected SBIIndex readIndex(Configuration conf, String part, SAMFileHeader header) throws IOException {
        SBIIndex index;
        try (SeekableStream in = this.fileSystemWrapper.open(conf, part);){
            index = SBIIndex.load((InputStream)in);
        }
        this.fileSystemWrapper.delete(conf, part);
        return index;
    }
}

