/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.file;

import htsjdk.samtools.IndexMerger;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.index.tabix.TabixIndex;
import htsjdk.tribble.index.tabix.TabixIndexMerger;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.IndexFileMerger;

public class TbiMerger
extends IndexFileMerger<TabixIndex, VCFHeader> {
    public TbiMerger(FileSystemWrapper fileSystemWrapper) {
        super(fileSystemWrapper);
    }

    @Override
    protected String getIndexExtension() {
        return TabixIndexWriteOption.getIndexExtension();
    }

    @Override
    protected IndexMerger<TabixIndex> newIndexMerger(OutputStream out, long headerLength) {
        return new TabixIndexMerger(out, headerLength);
    }

    @Override
    protected TabixIndex readIndex(Configuration conf, String part, VCFHeader header) throws IOException {
        TabixIndex index;
        try (SeekableStream in = this.fileSystemWrapper.open(conf, part);){
            index = new TabixIndex((InputStream)new BlockCompressedInputStream(in));
        }
        this.fileSystemWrapper.delete(conf, part);
        return index;
    }
}

