/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFlag;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.io.IOUtils;

class BamRecordGuesser
implements Closeable {
    private static final int READS_TO_CHECK = 10;
    private final BlockCompressedInputStream uncompressedBytes;
    private final int referenceSequenceCount;
    private final SAMFileHeader header;
    private final ByteBuffer buf = ByteBuffer.allocate(36).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer readNameBuffer = ByteBuffer.allocate(255).order(ByteOrder.LITTLE_ENDIAN);
    private final ByteBuffer cigarOpBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private static final Result NO_START = new Result(false, -1L);

    public BamRecordGuesser(SeekableStream ss, int referenceSequenceCount, SAMFileHeader header) {
        this.uncompressedBytes = new BlockCompressedInputStream(ss);
        this.referenceSequenceCount = referenceSequenceCount;
        this.header = header;
    }

    public boolean checkRecordStart(long vPos) {
        return this.checkRecordStart(vPos, 0);
    }

    private boolean checkRecordStart(long vPos, int successfulReads) {
        if (successfulReads == 10) {
            return true;
        }
        try {
            Result result = this.checkRecordStartInternal(vPos);
            return result.isStart() && this.checkRecordStart(result.getNextVPos(), successfulReads + 1);
        }
        catch (EOFException e) {
            return successfulReads > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.uncompressedBytes.close();
    }

    private Result checkRecordStartInternal(long vPos) throws IOException {
        int i;
        boolean primaryLine;
        BamRecordGuesser.seek(this.uncompressedBytes, vPos);
        BamRecordGuesser.readFully((InputStream)this.uncompressedBytes, this.buf.array(), 0, 36);
        int remainingBytes = this.buf.getInt(0);
        int id = this.buf.getInt(4);
        int pos = this.buf.getInt(8);
        if (id < -1 || id >= this.referenceSequenceCount || pos < -1) {
            return NO_START;
        }
        if (id >= 0 && pos > this.header.getSequenceDictionary().getSequence(id).getSequenceLength()) {
            return NO_START;
        }
        int nid = this.buf.getInt(24);
        int npos = this.buf.getInt(28);
        if (nid < -1 || nid >= this.referenceSequenceCount || npos < -1) {
            return NO_START;
        }
        if (nid >= 0 && npos > this.header.getSequenceDictionary().getSequence(nid).getSequenceLength()) {
            return NO_START;
        }
        int nameLength = this.buf.getInt(12) & 0xFF;
        if (nameLength < 2) {
            return NO_START;
        }
        int flags = this.buf.getInt(16) >>> 16;
        int numCigarOps = this.buf.getInt(16) & 0xFFFF;
        int cigarOpsLength = numCigarOps * 4;
        int seqLength = this.buf.getInt(20) + (this.buf.getInt(20) + 1) / 2;
        boolean mapped = SAMFlag.READ_UNMAPPED.isUnset(flags);
        boolean secondary = SAMFlag.SECONDARY_ALIGNMENT.isSet(flags);
        boolean supplementary = SAMFlag.SUPPLEMENTARY_ALIGNMENT.isSet(flags);
        boolean bl = primaryLine = !secondary && !supplementary;
        if (mapped && (seqLength == 0 && primaryLine || numCigarOps == 0)) {
            return NO_START;
        }
        this.readNameBuffer.position(0);
        this.readNameBuffer.limit(nameLength);
        BamRecordGuesser.readFully((InputStream)this.uncompressedBytes, this.readNameBuffer.array(), 0, nameLength);
        if (this.readNameBuffer.get(nameLength - 1) != 0) {
            return NO_START;
        }
        for (i = 0; i < nameLength - 1; ++i) {
            if (BamRecordGuesser.isValidReadNameCharacter(this.readNameBuffer.get(i))) continue;
            return NO_START;
        }
        for (i = 0; i < numCigarOps; ++i) {
            BamRecordGuesser.readFully((InputStream)this.uncompressedBytes, this.cigarOpBuffer.array(), 0, 4);
            int read = this.cigarOpBuffer.getInt(0);
            if (read == -1) {
                throw new EOFException();
            }
            if (this.isValidCigarOp(read)) continue;
            return NO_START;
        }
        int zeroMin = 32 + nameLength + cigarOpsLength + seqLength;
        if (remainingBytes >= zeroMin) {
            BamRecordGuesser.seek(this.uncompressedBytes, vPos);
            IOUtils.skipFully((InputStream)this.uncompressedBytes, (long)(4 + remainingBytes));
            return new Result(true, this.uncompressedBytes.getPosition());
        }
        return NO_START;
    }

    private static boolean isValidReadNameCharacter(byte b) {
        return 33 <= b && b <= 63 || 65 <= b && b <= 126;
    }

    private boolean isValidCigarOp(int read) {
        return (read & 0xF) <= 8;
    }

    private static void seek(BlockCompressedInputStream blockCompressedInputStream, long pos) throws IOException {
        try {
            blockCompressedInputStream.seek(pos);
        }
        catch (IOException e) {
            if (e.getMessage().startsWith("Invalid file pointer")) {
                throw new EOFException(e.getMessage());
            }
            throw e;
        }
    }

    private static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new EOFException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    static class Result {
        private final boolean start;
        private final long nextVPos;

        public Result(boolean start, long nextVPos) {
            this.start = start;
            this.nextVPos = nextVPos;
        }

        public boolean isStart() {
            return this.start;
        }

        public long getNextVPos() {
            return this.nextVPos;
        }
    }
}

