/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.cram;

import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.reference.BlockCompressedIndexedFastaSequenceFile;
import htsjdk.samtools.reference.FastaSequenceIndex;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.GZIIndex;
import htsjdk.samtools.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.disq_bio.disq.impl.file.FileSystemWrapper;

public class CramReferenceSourceBuilder {
    public static CRAMReferenceSource build(FileSystemWrapper fileSystemWrapper, Configuration conf, String referenceSourcePath) throws IOException {
        ReferenceSequenceFile refSeqFile;
        block19: {
            SeekableStream refIn = fileSystemWrapper.open(conf, referenceSourcePath);
            String indexPath = referenceSourcePath + ".fai";
            if (IOUtil.hasBlockCompressedExtension((String)referenceSourcePath)) {
                String gziIndexPath = referenceSourcePath + ".gzi";
                try (SeekableStream indexIn = fileSystemWrapper.open(conf, indexPath);
                     SeekableStream gziIndexIn = fileSystemWrapper.open(conf, gziIndexPath);){
                    FastaSequenceIndex index = new FastaSequenceIndex((InputStream)indexIn);
                    GZIIndex gziIndex = GZIIndex.loadIndex((String)gziIndexPath, (InputStream)gziIndexIn);
                    refSeqFile = new BlockCompressedIndexedFastaSequenceFile(referenceSourcePath, refIn, index, null, gziIndex);
                    break block19;
                }
            }
            try (SeekableStream indexIn = fileSystemWrapper.open(conf, indexPath);){
                FastaSequenceIndex index = new FastaSequenceIndex((InputStream)indexIn);
                refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((String)referenceSourcePath, (SeekableStream)refIn, (FastaSequenceIndex)index);
            }
        }
        return new ReferenceSource(refSeqFile);
    }
}

