/*
 * Decompiled with CFR 0.152.
 */
package org.disq_bio.disq.impl.formats.vcf;

import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.disq_bio.disq.TabixIndexWriteOption;
import org.disq_bio.disq.impl.file.FileSystemWrapper;
import org.disq_bio.disq.impl.file.HadoopFileSystemWrapper;
import org.disq_bio.disq.impl.file.HiddenFileFilter;
import org.disq_bio.disq.impl.file.Merger;
import org.disq_bio.disq.impl.file.TbiMerger;
import org.disq_bio.disq.impl.formats.vcf.AbstractVcfSink;
import org.disq_bio.disq.impl.formats.vcf.HeaderlessVcfOutputFormat;
import scala.Tuple2;

public class VcfSink
extends AbstractVcfSink {
    private FileSystemWrapper fileSystemWrapper = new HadoopFileSystemWrapper();

    @Override
    public void save(JavaSparkContext jsc, VCFHeader vcfHeader, JavaRDD<VariantContext> variants, String path, String tempPartsDirectory, List<String> indexesToEnable) throws IOException {
        OutputStream out;
        Broadcast vcfHeaderBroadcast = jsc.broadcast((Object)vcfHeader);
        boolean compressed = path.endsWith(".bgz") || path.endsWith(".gz");
        boolean writeTbiFile = compressed && indexesToEnable.contains(TabixIndexWriteOption.getIndexExtension());
        variants.mapPartitions((FlatMapFunction & Serializable)readIterator -> {
            HeaderlessVcfOutputFormat.setHeader((VCFHeader)vcfHeaderBroadcast.getValue());
            HeaderlessVcfOutputFormat.setBlockCompress(compressed);
            HeaderlessVcfOutputFormat.setWriteTbiFile(writeTbiFile);
            return readIterator;
        }).mapToPair((PairFunction & Serializable)variantContext -> new Tuple2(null, variantContext)).saveAsNewAPIHadoopFile(tempPartsDirectory, Void.class, VariantContext.class, HeaderlessVcfOutputFormat.class, jsc.hadoopConfiguration());
        String headerFile = tempPartsDirectory + "/header" + (compressed ? ".bgz" : "");
        try (OutputStream headerOut = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), headerFile);){
            out = compressed ? new BlockCompressedOutputStream(headerOut, (Path)null) : headerOut;
            VariantContextWriter writer = new VariantContextWriterBuilder().clearOptions().setOutputVCFStream(out).build();
            writer.writeHeader(vcfHeader);
            out.flush();
        }
        if (compressed) {
            String terminatorFile = tempPartsDirectory + "/terminator";
            out = this.fileSystemWrapper.create(jsc.hadoopConfiguration(), terminatorFile);
            try {
                out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        List<FileSystemWrapper.FileStatus> vcfParts = this.fileSystemWrapper.listDirectoryStatus(jsc.hadoopConfiguration(), tempPartsDirectory).stream().filter(fs -> new HiddenFileFilter().test(fs.getPath())).collect(Collectors.toList());
        List<Long> partLengths = vcfParts.stream().mapToLong(FileSystemWrapper.FileStatus::getLength).boxed().collect(Collectors.toList());
        new Merger(this.fileSystemWrapper).mergeParts(jsc.hadoopConfiguration(), vcfParts, path);
        long fileLength = this.fileSystemWrapper.getFileLength(jsc.hadoopConfiguration(), path);
        if (writeTbiFile) {
            new TbiMerger(this.fileSystemWrapper).mergeParts(jsc.hadoopConfiguration(), tempPartsDirectory, path + TabixIndexWriteOption.getIndexExtension(), vcfHeader, partLengths, fileLength);
        }
        this.fileSystemWrapper.delete(jsc.hadoopConfiguration(), tempPartsDirectory);
    }
}

