/*
 * Decompiled with CFR 0.152.
 */
package org.djodjo.json;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.djodjo.json.JsonBoolean;
import org.djodjo.json.JsonElement;
import org.djodjo.json.JsonNull;
import org.djodjo.json.JsonNumber;
import org.djodjo.json.JsonObject;
import org.djodjo.json.JsonWriter;
import org.djodjo.json.exception.JsonException;
import org.djodjo.json.util.Freezable;
import org.djodjo.json.util.Util;

public final class JsonArray
extends JsonElement
implements List<JsonElement>,
Freezable<JsonArray> {
    private volatile boolean frozen = false;
    private final List<JsonElement> values;

    public JsonArray() {
        this.values = new ArrayList<JsonElement>();
    }

    public JsonArray(Collection copyFrom) throws JsonException {
        this();
        if (copyFrom != null) {
            for (Object aCopyFrom : copyFrom) {
                this.put(JsonElement.wrap(aCopyFrom));
            }
        }
    }

    public JsonArray(Object array) throws JsonException {
        if (!array.getClass().isArray()) {
            throw new JsonException("Not a primitive array: " + array.getClass());
        }
        int length = Array.getLength(array);
        this.values = new ArrayList<JsonElement>(length);
        for (int i = 0; i < length; ++i) {
            this.put(JsonElement.wrap(Array.get(array, i)));
        }
    }

    public int length() {
        return this.values.size();
    }

    public JsonArray put(boolean value) {
        return this.put(new JsonBoolean(value));
    }

    public JsonArray put(double value) throws JsonException {
        return this.put(new JsonNumber(value));
    }

    public JsonArray put(int value) {
        return this.put(new JsonNumber(value));
    }

    public JsonArray put(long value) {
        return this.put(new JsonNumber(value));
    }

    public JsonArray put(Object value) throws JsonException {
        return this.put(JsonArray.wrap(value));
    }

    public JsonArray put(JsonElement value) {
        if (value != null) {
            this.values.add(value);
        }
        return this;
    }

    public JsonArray put(int index, boolean value) throws JsonException {
        return this.put(index, (Object)value);
    }

    public JsonArray put(int index, double value) throws JsonException {
        return this.put(index, (Object)value);
    }

    public JsonArray put(int index, int value) throws JsonException {
        return this.put(index, (Object)value);
    }

    public JsonArray put(int index, long value) throws JsonException {
        return this.put(index, (Object)value);
    }

    public JsonArray put(int index, Object value) throws JsonException {
        while (this.values.size() <= index) {
            this.values.add(new JsonNull());
        }
        this.values.set(index, JsonArray.wrap(value));
        return this;
    }

    public boolean isNull(int index) {
        JsonElement value = this.opt(index);
        return value == null || ((Object)value).equals(new JsonNull());
    }

    @Override
    public JsonElement get(int index) throws JsonException {
        try {
            JsonElement value = this.values.get(index);
            if (value == null) {
                throw new JsonException("Value at " + index + " is null.");
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            throw new JsonException("Index " + index + " out of range [0.." + this.values.size() + ")");
        }
    }

    @Override
    public JsonElement set(int i, JsonElement jsonElement) {
        this.checkIfFrozen();
        return this.values.set(i, jsonElement);
    }

    @Override
    public void add(int i, JsonElement jsonElement) {
        this.checkIfFrozen();
        this.values.add(i, jsonElement);
    }

    public JsonElement opt(int index) {
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public JsonElement remove(int index) {
        this.checkIfFrozen();
        if (index < 0 || index >= this.values.size()) {
            return null;
        }
        return this.values.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public ListIterator<JsonElement> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<JsonElement> listIterator(int i) {
        return this.values.listIterator(i);
    }

    @Override
    public List<JsonElement> subList(int i, int i2) {
        return this.values.subList(i, i2);
    }

    public Boolean getBoolean(int index, boolean strict) throws JsonException {
        JsonElement el = this.get(index);
        Boolean res = null;
        if (strict && !el.isBoolean()) {
            throw Util.typeMismatch(index, el, "boolean", true);
        }
        if (el.isBoolean()) {
            res = el.asBoolean();
        }
        if (el.isString()) {
            res = Util.toBoolean(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(index, el, "boolean", strict);
        }
        return res;
    }

    public Boolean getBoolean(int index) throws JsonException {
        return this.getBoolean(index, false);
    }

    public Boolean optBoolean(int index) {
        return this.optBoolean(index, null);
    }

    public Boolean optBoolean(int index, Boolean fallback) {
        return this.optBoolean(index, fallback, false);
    }

    public Boolean optBoolean(int index, Boolean fallback, boolean strict) {
        try {
            return this.getBoolean(index, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Double getDouble(int index, boolean strict) throws JsonException {
        JsonElement el = this.get(index);
        Double res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(index, el, "double", true);
        }
        if (el.isNumber()) {
            res = el.asDouble();
        }
        if (el.isString()) {
            res = Util.toDouble(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(index, el, "double", strict);
        }
        return res;
    }

    public Double getDouble(int index) throws JsonException {
        return this.getDouble(index, false);
    }

    public Double optDouble(int index) {
        return this.optDouble(index, null);
    }

    public Double optDouble(int index, Double fallback) {
        return this.optDouble(index, fallback, false);
    }

    public Double optDouble(int index, Double fallback, boolean strict) {
        try {
            return this.getDouble(index, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Integer getInt(int index) throws JsonException {
        return this.getInt(index, false);
    }

    public Integer getInt(int index, boolean strict) throws JsonException {
        JsonElement el = this.get(index);
        Integer res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(index, el, "int", true);
        }
        if (el.isNumber()) {
            res = el.asInt();
        }
        if (el.isString()) {
            res = Util.toInteger(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(index, el, "int", strict);
        }
        return res;
    }

    public Integer optInt(int index) {
        return this.optInt(index, null);
    }

    public Integer optInt(int index, Integer fallback) {
        return this.optInt(index, fallback, false);
    }

    public Integer optInt(int index, Integer fallback, boolean strict) {
        try {
            return this.getInt(index, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Long getLong(int index, boolean strict) throws JsonException {
        JsonElement el = this.get(index);
        Long res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(index, el, "long", true);
        }
        if (el.isNumber()) {
            res = el.asLong();
        }
        if (el.isString()) {
            res = Util.toLong(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(index, el, "long", strict);
        }
        return res;
    }

    public Long getLong(int index) throws JsonException {
        return this.getLong(index, false);
    }

    public Long optLong(int index) {
        return this.optLong(index, null);
    }

    public Long optLong(int index, Long fallback) {
        return this.optLong(index, fallback, false);
    }

    public Long optLong(int index, Long fallback, boolean strict) {
        try {
            return this.getLong(index, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public String getString(int index, boolean strict) throws JsonException {
        JsonElement el = this.get(index);
        String res = null;
        if (strict && !el.isString()) {
            throw Util.typeMismatch(index, el, "string", true);
        }
        res = el.toString();
        if (res == null) {
            throw Util.typeMismatch(index, el, "string", strict);
        }
        return res;
    }

    public String getString(int index) throws JsonException {
        return this.getString(index, false);
    }

    public String optString(int index) {
        return this.optString(index, null);
    }

    public String optString(int index, String fallback) {
        return this.optString(index, fallback, false);
    }

    public String optString(int index, String fallback, boolean strict) {
        try {
            return this.getString(index, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public JsonArray getJsonArray(int index) throws JsonException {
        JsonElement el = this.get(index);
        if (!el.isJsonArray()) {
            throw Util.typeMismatch(index, el, "JsonArray");
        }
        return el.asJsonArray();
    }

    public JsonArray optJsonArray(int index) {
        JsonElement el;
        try {
            el = this.get(index);
        }
        catch (JsonException e) {
            return null;
        }
        if (!el.isJsonArray()) {
            return null;
        }
        return el.asJsonArray();
    }

    public JsonObject getJsonObject(int index) throws JsonException {
        JsonElement el = this.get(index);
        if (!el.isJsonObject()) {
            throw Util.typeMismatch(index, el, "JsonObject");
        }
        return el.asJsonObject();
    }

    public JsonObject optJsonObject(int index) {
        JsonElement el;
        try {
            el = this.get(index);
        }
        catch (JsonException e) {
            return null;
        }
        if (!el.isJsonObject()) {
            return null;
        }
        return el.asJsonObject();
    }

    public JsonObject toJsonObject(JsonArray names) throws JsonException {
        JsonObject result = new JsonObject();
        int length = Math.min(names.length(), this.values.size());
        if (length == 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            String name = names.opt(i).toString();
            if (this.opt(i) == null) continue;
            result.put(name, this.opt(i));
        }
        return result;
    }

    public ArrayList<String> toArrayList() {
        ArrayList<String> res = new ArrayList<String>();
        for (JsonElement el : this.values) {
            res.add(el.toString());
        }
        return res;
    }

    public boolean isOnlyStrings() {
        for (JsonElement el : this.values) {
            if (el.isString()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyNumbers() {
        for (JsonElement el : this.values) {
            if (el.isNumber()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyBooleans() {
        for (JsonElement el : this.values) {
            if (el.isBoolean()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyObjects() {
        for (JsonElement el : this.values) {
            if (el.isJsonObject()) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyArrays() {
        for (JsonElement el : this.values) {
            if (el.isJsonArray()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void write(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (JsonElement e : this) {
            e.write(writer);
        }
        writer.endArray();
    }

    @Override
    public boolean isJsonArray() {
        return true;
    }

    @Override
    public JsonArray asJsonArray() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JsonArray && ((JsonArray)o).values.equals(this.values);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.values.contains(o);
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        return this.values.toArray(ts);
    }

    @Override
    public boolean add(JsonElement jsonElement) {
        return this.values.add(jsonElement);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.values.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends JsonElement> jsonElements) {
        return this.values.addAll(jsonElements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends JsonElement> jsonElements) {
        return this.addAll(jsonElements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.values.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.values.retainAll(objects);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public String getJsonType() {
        return "array";
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public JsonArray freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public JsonArray cloneAsThawed() {
        try {
            return JsonElement.readFrom(this.toString()).asJsonArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JsonException("Cannot Recreate Json Array", e);
        }
    }

    public void checkIfFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen JsonArray instance.");
        }
    }
}

