/*
 * Decompiled with CFR 0.152.
 */
package org.djodjo.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.djodjo.json.JsonArray;
import org.djodjo.json.JsonBoolean;
import org.djodjo.json.JsonElement;
import org.djodjo.json.JsonNull;
import org.djodjo.json.JsonNumber;
import org.djodjo.json.JsonWriter;
import org.djodjo.json.exception.JsonException;
import org.djodjo.json.util.Freezable;
import org.djodjo.json.util.LinkedTreeMap;
import org.djodjo.json.util.Util;

public final class JsonObject
extends JsonElement
implements Iterable<Map.Entry<String, JsonElement>>,
Freezable<JsonObject> {
    private volatile boolean frozen = false;
    private final LinkedTreeMap<String, JsonElement> nameValuePairs = new LinkedTreeMap();

    public JsonObject() {
    }

    public JsonObject(Map copyFrom) throws JsonException {
        this();
        Map contentsTyped = copyFrom;
        for (Map.Entry entry : contentsTyped.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            this.nameValuePairs.put(key, JsonObject.wrap(entry.getValue()));
        }
    }

    public int length() {
        return this.nameValuePairs.size();
    }

    public JsonObject put(String name, boolean value) throws JsonException {
        return this.put(name, new JsonBoolean(value));
    }

    public JsonObject put(String name, double value) throws JsonException {
        return this.put(name, new JsonNumber(value));
    }

    public JsonObject put(String name, int value) throws JsonException {
        return this.put(name, new JsonNumber(value));
    }

    public JsonObject put(String name, long value) throws JsonException {
        return this.put(name, new JsonNumber(value));
    }

    public JsonObject put(String name, Object value) throws JsonException {
        return this.put(name, JsonObject.wrap(value));
    }

    public JsonObject put(String name, JsonElement value) throws JsonException {
        this.checkIfFrozen();
        if (value == null) {
            value = new JsonNull();
        }
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    public JsonObject putOpt(String name, Object value) throws JsonException {
        if (name == null || value == null) {
            return this;
        }
        return this.put(name, value);
    }

    public JsonObject accumulate(String name, Object value) throws JsonException {
        this.checkIfFrozen();
        JsonElement current = this.nameValuePairs.get(this.checkName(name));
        if (current == null) {
            return this.put(name, value);
        }
        if (current instanceof JsonArray) {
            JsonArray array = (JsonArray)current;
            array.put(value);
        } else {
            JsonArray array = new JsonArray();
            array.put((Object)current);
            array.put(value);
            this.nameValuePairs.put(name, array);
        }
        return this;
    }

    public JsonObject append(String name, Object value) throws JsonException {
        JsonArray array;
        this.checkIfFrozen();
        JsonElement current = this.nameValuePairs.get(this.checkName(name));
        if (current instanceof JsonArray) {
            array = (JsonArray)current;
        } else if (current == null) {
            JsonArray newArray = new JsonArray();
            this.nameValuePairs.put(name, newArray);
            array = newArray;
        } else {
            throw new JsonException("Key " + name + " is not a JsonArray");
        }
        array.put(value);
        return this;
    }

    String checkName(String name) {
        if (name == null) {
            throw new JsonException("Names must be non-null");
        }
        return name;
    }

    public Object remove(String name) {
        this.checkIfFrozen();
        return this.nameValuePairs.remove(name);
    }

    public boolean isNull(String name) {
        JsonElement value = this.nameValuePairs.get(name);
        return value.isNull();
    }

    public boolean has(String name) {
        return this.nameValuePairs.containsKey(name);
    }

    public JsonElement get(String name) throws JsonException {
        JsonElement result = this.nameValuePairs.get(name);
        if (result == null) {
            throw new JsonException("No value for " + name + ", in: " + this.toString());
        }
        return result;
    }

    public JsonElement opt(String name) {
        return this.nameValuePairs.get(name);
    }

    public Boolean getBoolean(String name, boolean strict) throws JsonException {
        JsonElement el = this.get(name);
        Boolean res = null;
        if (strict && !el.isBoolean()) {
            throw Util.typeMismatch(name, el, "boolean", true);
        }
        if (el.isBoolean()) {
            res = el.asBoolean();
        }
        if (el.isString()) {
            res = Util.toBoolean(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(name, el, "boolean", strict);
        }
        return res;
    }

    public Boolean getBoolean(String name) throws JsonException {
        return this.getBoolean(name, true);
    }

    public Boolean optBoolean(String name) {
        return this.optBoolean(name, null);
    }

    public Boolean optBoolean(String name, Boolean fallback) {
        return this.optBoolean(name, fallback, true);
    }

    public Boolean optBoolean(String name, Boolean fallback, boolean strict) {
        try {
            return this.getBoolean(name, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Double getDouble(String name, boolean strict) throws JsonException {
        JsonElement el = this.get(name);
        Double res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(name, el, "double", true);
        }
        if (el.isNumber()) {
            res = el.asDouble();
        }
        if (el.isString()) {
            res = Util.toDouble(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(name, el, "double", strict);
        }
        return res;
    }

    public Double getDouble(String name) throws JsonException {
        return this.getDouble(name, true);
    }

    public Double optDouble(String name) {
        return this.optDouble(name, null);
    }

    public Double optDouble(String name, Double fallback) {
        return this.optDouble(name, fallback, true);
    }

    public Double optDouble(String name, Double fallback, boolean strict) {
        try {
            return this.getDouble(name, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Integer getInt(String name, boolean strict) throws JsonException {
        JsonElement el = this.get(name);
        Integer res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(name, el, "int", true);
        }
        if (el.isNumber()) {
            res = el.asInt();
        }
        if (el.isString()) {
            res = Util.toInteger(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(name, el, "int", strict);
        }
        return res;
    }

    public Integer getInt(String name) throws JsonException {
        return this.getInt(name, true);
    }

    public Integer optInt(String name) {
        return this.optInt(name, null);
    }

    public Integer optInt(String name, Integer fallback) {
        return this.optInt(name, fallback, true);
    }

    public Integer optInt(String name, Integer fallback, boolean strict) {
        try {
            return this.getInt(name, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public Long getLong(String name, boolean strict) throws JsonException {
        JsonElement el = this.get(name);
        Long res = null;
        if (strict && !el.isNumber()) {
            throw Util.typeMismatch(name, el, "long", true);
        }
        if (el.isNumber()) {
            res = el.asLong();
        }
        if (el.isString()) {
            res = Util.toLong(el.asString());
        }
        if (res == null) {
            throw Util.typeMismatch(name, el, "long", strict);
        }
        return res;
    }

    public Long getLong(String name) throws JsonException {
        return this.getLong(name, true);
    }

    public Long optLong(String name) {
        return this.optLong(name, null);
    }

    public Long optLong(String name, Long fallback) {
        return this.optLong(name, fallback, true);
    }

    public Long optLong(String name, Long fallback, boolean strict) {
        try {
            return this.getLong(name, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public String getString(String name, boolean strict) throws JsonException {
        JsonElement el = this.get(name);
        String res = null;
        if (strict && !el.isString()) {
            throw Util.typeMismatch(name, el, "string", true);
        }
        res = el.toString();
        if (res == null) {
            throw Util.typeMismatch(name, el, "string", strict);
        }
        return res;
    }

    public String getString(String name) throws JsonException {
        return this.getString(name, true);
    }

    public String optString(String name) {
        return this.optString(name, null);
    }

    public String optString(String name, String fallback) {
        return this.optString(name, fallback, true);
    }

    public String optString(String name, String fallback, boolean strict) {
        try {
            return this.getString(name, strict);
        }
        catch (JsonException e) {
            return fallback;
        }
    }

    public JsonArray getJsonArray(String name) throws JsonException {
        JsonElement el = this.get(name);
        if (!el.isJsonArray()) {
            throw Util.typeMismatch(name, el, "JsonArray");
        }
        return el.asJsonArray();
    }

    public JsonArray optJsonArray(String name) {
        JsonElement el = null;
        try {
            el = this.get(name);
        }
        catch (JsonException e) {
            return null;
        }
        if (!el.isJsonArray()) {
            return null;
        }
        return el.asJsonArray();
    }

    public JsonObject getJsonObject(String name) throws JsonException {
        JsonElement el = this.get(name);
        if (!el.isJsonObject()) {
            throw Util.typeMismatch(name, el, "JsonObject");
        }
        return el.asJsonObject();
    }

    public JsonObject optJsonObject(String name) {
        JsonElement el = null;
        try {
            el = this.get(name);
        }
        catch (JsonException e) {
            return null;
        }
        if (!el.isJsonObject()) {
            return null;
        }
        return el.asJsonObject();
    }

    public JsonArray toJsonArray(JsonArray names) throws JsonException {
        JsonArray result = new JsonArray();
        if (names == null) {
            return null;
        }
        int length = names.length();
        if (length == 0) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            String name = Util.toString(names.opt(i));
            result.put(this.opt(name));
        }
        return result;
    }

    public Iterator<String> keys() {
        return this.nameValuePairs.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.nameValuePairs.keySet();
    }

    public Collection<JsonElement> valuesSet() {
        if (this.isFrozen()) {
            Collections.unmodifiableCollection(this.nameValuePairs.values());
        }
        return this.nameValuePairs.values();
    }

    public JsonArray names() throws JsonException {
        return this.nameValuePairs.isEmpty() ? null : new JsonArray(new ArrayList<String>(this.nameValuePairs.keySet()));
    }

    @Override
    public void write(JsonWriter writer) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, JsonElement> e : this.nameValuePairs.entrySet()) {
            writer.name(e.getKey());
            e.getValue().write(writer);
        }
        writer.endObject();
    }

    @Override
    public boolean isJsonObject() {
        return true;
    }

    @Override
    public JsonObject asJsonObject() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JsonObject && ((JsonObject)o).nameValuePairs.equals(this.nameValuePairs);
    }

    @Override
    public String getJsonType() {
        return "object";
    }

    @Override
    public Iterator<Map.Entry<String, JsonElement>> iterator() {
        return this.nameValuePairs.entrySet().iterator();
    }

    public JsonObject merge(JsonObject another) {
        for (Map.Entry<String, JsonElement> anotherEntry : another) {
            JsonElement curr = this.opt(anotherEntry.getKey());
            if (curr == null) {
                try {
                    this.put(anotherEntry.getKey(), anotherEntry.getValue());
                }
                catch (JsonException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!curr.isJsonObject() || !anotherEntry.getValue().isJsonObject()) continue;
            curr.asJsonObject().merge(anotherEntry.getValue().asJsonObject());
        }
        return this;
    }

    public JsonObject clear() {
        this.nameValuePairs.clear();
        return this;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public JsonObject freeze() {
        this.frozen = true;
        return this;
    }

    @Override
    public JsonObject cloneAsThawed() {
        try {
            return JsonElement.readFrom(this.toString()).asJsonObject();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JsonException("Cannot Recreate Json Object", e);
        }
    }

    public void checkIfFrozen() {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException("Attempt to modify a frozen JsonObject instance.");
        }
    }
}

