/*
 * Decompiled with CFR 0.152.
 */
package org.djodjo.json;

import java.io.IOException;
import org.djodjo.json.JsonElement;
import org.djodjo.json.JsonWriter;

public final class JsonString
extends JsonElement {
    private final String value;

    public JsonString(String value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.value = value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String toString() {
        return new String(this.value);
    }

    @Override
    public String asString() {
        return new String(this.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JsonString && ((JsonString)o).value.equals(this.value) || o != null && o.equals(this.value);
    }

    @Override
    public void write(JsonWriter writer) throws IOException {
        writer.value(this.value);
    }

    @Override
    public String getJsonType() {
        return "string";
    }
}

