/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.equilibrium;

import java.util.ArrayList;
import java.util.List;
import org.dmfs.equilibrium.Displaced;
import org.dmfs.equilibrium.Graph;
import org.dmfs.equilibrium.Node;
import org.dmfs.equilibrium.Vector;
import org.dmfs.equilibrium.vector.Diff;
import org.dmfs.equilibrium.vector.Normalized;
import org.dmfs.equilibrium.vector.Scaled;
import org.dmfs.equilibrium.vector.Sum;
import org.dmfs.equilibrium.vector.predicate.EqualTo;
import org.dmfs.equilibrium.vector.single.LengthOf;
import org.dmfs.jems2.Function;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Sieved;
import org.dmfs.jems2.predicate.Having;
import org.dmfs.jems2.predicate.Not;
import org.dmfs.jems2.single.Collected;

public final class ForceDirected<T>
implements Function<Graph<T>, Graph<T>> {
    private final Function<Double, Double> attractiveForce;
    private final Function<Double, Double> repulsiveForce;

    public ForceDirected(Function<Double, Double> attractiveForce, Function<Double, Double> repulsiveForce) {
        this.attractiveForce = attractiveForce;
        this.repulsiveForce = repulsiveForce;
    }

    public Graph<T> value(final Graph<T> input) {
        final List nodes = (List)new Collected(ArrayList::new, (Iterable)new Mapped(node -> {
            Sum pos = new Sum(node.pos(), (Vector)new Sum((Iterable<? extends Vector>)new Mapped(n -> this.netForce(node.pos(), n.pos(), input.linkWeight((Node<T>)node, (Node<T>)n), node.mass(), node.charge() * n.charge()), (Iterable)new Sieved((Predicate)new Having(Node::pos, (Predicate)new Not((Predicate)new EqualTo(node.pos()))), input.nodes()))));
            return new Displaced(node, pos);
        }, input.nodes())).value();
        return new Graph<T>(){

            @Override
            public Iterable<Node<T>> nodes() {
                return nodes;
            }

            @Override
            public double linkWeight(Node<T> a, Node<T> b) {
                return input.linkWeight(a, b);
            }
        };
    }

    private Vector netForce(Vector from, Vector to, double linkWeight, double mass, double charges) {
        double distance = (Double)new LengthOf(new Diff(from, to)).value();
        return new Scaled(new Normalized(from, to), (linkWeight * (Double)this.attractiveForce.value((Object)distance) - charges * (Double)this.repulsiveForce.value((Object)distance)) / mass);
    }
}

