/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.iterators.decorators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;
import org.dmfs.iterators.EmptyIterator;
import org.dmfs.iterators.elementary.Seq;

public final class Flattened<E>
extends AbstractBaseIterator<E> {
    private final Iterator<Iterable<E>> mIterables;
    private Iterator<E> mCurrentIterator;

    @SafeVarargs
    public Flattened(Iterable<E> ... iterables) {
        this(new Seq<Iterable<E>>(iterables));
    }

    public Flattened(Iterator<Iterable<E>> iterableIterator) {
        this.mIterables = iterableIterator;
        this.mCurrentIterator = EmptyIterator.instance();
    }

    @Override
    public boolean hasNext() {
        while (!this.mCurrentIterator.hasNext() && this.mIterables.hasNext()) {
            this.mCurrentIterator = this.mIterables.next().iterator();
        }
        return this.mCurrentIterator.hasNext();
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements to iterate.");
        }
        return this.mCurrentIterator.next();
    }
}

