/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.optional.adapters;

import java.util.NoSuchElementException;
import org.dmfs.jems.predicate.Predicate;
import org.dmfs.jems.single.Single;
import org.dmfs.jems.single.elementary.ValueSingle;
import org.dmfs.optional.Absent;
import org.dmfs.optional.Optional;
import org.dmfs.optional.Present;

public final class Conditional<T>
implements Optional<T> {
    private final Predicate<T> mPredicate;
    private final Single<T> mTargetSingle;
    private Optional<T> mCachedDelegate;

    public Conditional(Predicate<T> predicate, Single<T> targetSingle) {
        this.mPredicate = predicate;
        this.mTargetSingle = targetSingle;
    }

    public Conditional(Predicate<T> predicate, T targetValue) {
        this(predicate, new ValueSingle<T>(targetValue));
    }

    @Override
    public boolean isPresent() {
        return this.cachedDelegate().isPresent();
    }

    @Override
    public T value(T defaultValue) {
        return this.cachedDelegate().value(defaultValue);
    }

    @Override
    public T value() throws NoSuchElementException {
        return this.cachedDelegate().value();
    }

    private Optional<T> cachedDelegate() {
        if (this.mCachedDelegate == null) {
            T targetValue = this.mTargetSingle.value();
            this.mCachedDelegate = this.mPredicate.satisfiedBy(targetValue) ? new Present<T>(targetValue) : Absent.absent();
        }
        return this.mCachedDelegate;
    }
}

