/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterator.generators;

import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;

public final class IntSequenceGenerator
extends AbstractBaseIterator<Integer> {
    private long mNext;
    private final int mStep;

    public IntSequenceGenerator() {
        this(0, 1);
    }

    public IntSequenceGenerator(int next) {
        this(next, 1);
    }

    public IntSequenceGenerator(int next, int step) {
        this.mNext = next;
        this.mStep = step;
    }

    @Override
    public boolean hasNext() {
        return this.mNext >= Integer.MIN_VALUE && this.mNext <= Integer.MAX_VALUE;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Generator overflow. Next value is not an Integer anymore.");
        }
        int result = (int)this.mNext;
        this.mNext += (long)this.mStep;
        return result;
    }
}

