/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.charsequence.elementary;

import java.util.Locale;
import org.dmfs.jems.single.Single;
import org.dmfs.jems.single.elementary.Frozen;

public final class Ascii
implements CharSequence {
    private final byte[] mData;
    private final int mStart;
    private final int mEnd;
    private final Single<String> mToString;

    public Ascii(byte ... data) {
        this(data, 0, data.length);
    }

    public Ascii(byte[] data, int start, int end) {
        this.mData = data;
        this.mStart = start;
        this.mEnd = end;
        this.mToString = new Frozen<String>(new Single<String>(){

            @Override
            public String value() {
                StringBuilder stringBuilder = new StringBuilder(Ascii.this.mEnd - Ascii.this.mStart);
                for (int i = Ascii.this.mStart; i < Ascii.this.mEnd; ++i) {
                    stringBuilder.append((char)Ascii.this.mData[i]);
                }
                return stringBuilder.toString();
            }
        });
    }

    @Override
    public int length() {
        return this.mEnd - this.mStart;
    }

    @Override
    public char charAt(int i) {
        if (i < 0 || i >= this.mEnd - this.mStart) {
            throw new ArrayIndexOutOfBoundsException(String.format(Locale.ENGLISH, "Illegal position %d in CharSequence of length %d", i, this.mEnd - this.mStart));
        }
        return (char)this.mData[i + this.mStart];
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format(Locale.ENGLISH, "sub-sequences can not start at a negative index %d", i));
        }
        if (i1 < i) {
            throw new ArrayIndexOutOfBoundsException(String.format(Locale.ENGLISH, "end (%d) can not be smaller than start (%d)", i1, i));
        }
        if (i1 > this.mEnd - this.mStart) {
            throw new ArrayIndexOutOfBoundsException(String.format(Locale.ENGLISH, "End index %d exceeds length of CharSequence %d", i1, this.mEnd - this.mStart));
        }
        return new Ascii(this.mData, this.mStart + i, this.mStart + i1);
    }

    @Override
    public String toString() {
        return this.mToString.value();
    }
}

