/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterator.composite;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.iterators.AbstractBaseIterator;
import org.dmfs.jems.function.BiFunction;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Next;
import org.dmfs.jems.pair.Pair;
import org.dmfs.jems.pair.elementary.LeftSidedPair;
import org.dmfs.jems.pair.elementary.RightSidedPair;
import org.dmfs.jems.pair.elementary.ValuePair;

public final class Diff<Left, Right>
extends AbstractBaseIterator<Pair<Optional<Left>, Optional<Right>>> {
    private final Iterator<Left> mLefts;
    private final Iterator<Right> mRights;
    private final BiFunction<Left, Right, Integer> mComparatorFunction;
    private Optional<Left> mNextLeft;
    private Optional<Right> mNextRight;

    public Diff(Iterator<Left> leftIterator, Iterator<Right> rightIterator, BiFunction<Left, Right, Integer> comparatorFunction) {
        this.mLefts = leftIterator;
        this.mRights = rightIterator;
        this.mComparatorFunction = comparatorFunction;
        this.mNextLeft = new Next<Left>(leftIterator);
        this.mNextRight = new Next<Right>(rightIterator);
    }

    @Override
    public boolean hasNext() {
        return this.mNextLeft.isPresent() || this.mNextRight.isPresent();
    }

    @Override
    public Pair<Optional<Left>, Optional<Right>> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        if (!this.mNextLeft.isPresent()) {
            Optional<Right> right = this.mNextRight;
            this.mNextRight = new Next<Right>(this.mRights);
            return new RightSidedPair(right);
        }
        if (!this.mNextRight.isPresent()) {
            Optional<Left> left = this.mNextLeft;
            this.mNextLeft = new Next<Left>(this.mLefts);
            return new LeftSidedPair(left);
        }
        int result = this.mComparatorFunction.value(this.mNextLeft.value(), this.mNextRight.value());
        if (result < 0) {
            Optional<Left> nextLeft = this.mNextLeft;
            this.mNextLeft = new Next<Left>(this.mLefts);
            return new LeftSidedPair(nextLeft);
        }
        if (result > 0) {
            Optional<Right> nextRight = this.mNextRight;
            this.mNextRight = new Next<Right>(this.mRights);
            return new RightSidedPair(nextRight);
        }
        Optional<Left> nextLeft = this.mNextLeft;
        Optional<Right> nextRight = this.mNextRight;
        this.mNextLeft = new Next<Left>(this.mLefts);
        this.mNextRight = new Next<Right>(this.mRights);
        return new ValuePair<Optional<Left>, Optional<Right>>(nextLeft, nextRight);
    }
}

