/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.single.elementary;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Locale;
import org.dmfs.iterables.decorators.Mapped;
import org.dmfs.iterators.Function;
import org.dmfs.jems.function.BiFunction;
import org.dmfs.jems.function.elementary.SingleFunction;
import org.dmfs.jems.iterable.elementary.Seq;
import org.dmfs.jems.messagedigest.MessageDigestFactory;
import org.dmfs.jems.single.Single;
import org.dmfs.jems.single.elementary.Reduced;
import org.dmfs.jems.single.elementary.ValueSingle;

public final class Digest
implements Single<byte[]> {
    private final MessageDigestFactory mMessageDigestFactory;
    private final Iterable<Single<byte[]>> mParts;

    public Digest(MessageDigestFactory messageDigestFactory, byte[] ... parts) {
        this(messageDigestFactory, new Mapped(new Seq((T[])parts), new SingleFunction()));
    }

    public Digest(MessageDigestFactory messageDigestFactory, CharSequence ... parts) {
        this(messageDigestFactory, "UTF-8", parts);
    }

    public Digest(MessageDigestFactory messageDigestFactory, final String encoding, CharSequence ... parts) {
        this(messageDigestFactory, new Mapped<CharSequence, Single<byte[]>>(new Seq<CharSequence>(parts), new Function<CharSequence, Single<byte[]>>(){

            @Override
            public Single<byte[]> apply(CharSequence bytes) {
                try {
                    return new ValueSingle<byte[]>(bytes.toString().getBytes(encoding));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(String.format(Locale.ENGLISH, "%s encoding not supported by runtime", encoding), e);
                }
            }
        }));
    }

    @SafeVarargs
    public Digest(MessageDigestFactory messageDigestFactory, Single<byte[]> ... parts) {
        this(messageDigestFactory, new Seq<Single<byte[]>>(parts));
    }

    public Digest(MessageDigestFactory messageDigestFactory, Iterable<Single<byte[]>> parts) {
        this.mMessageDigestFactory = messageDigestFactory;
        this.mParts = parts;
    }

    @Override
    public byte[] value() {
        return new Reduced<Single<byte[]>, MessageDigest>(this.mMessageDigestFactory::newInstance, new DigestFunction(), this.mParts).value().digest();
    }

    private static final class DigestFunction
    implements BiFunction<MessageDigest, Single<byte[]>, MessageDigest> {
        private DigestFunction() {
        }

        @Override
        public MessageDigest value(MessageDigest messageDigest, Single<byte[]> bytes) {
            messageDigest.update(bytes.value());
            return messageDigest;
        }
    }
}

