/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems.iterator.decorators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.jems.generator.Generator;
import org.dmfs.jems.iterator.adapters.Infinite;

public final class Truncated<T>
implements Iterator<T> {
    private int mRemaining;
    private final Iterator<T> mDelegate;

    public Truncated(int remaining, Generator<T> delegate) {
        this(remaining, new Infinite<T>(delegate));
    }

    public Truncated(int remaining, Iterator<T> delegate) {
        this.mRemaining = remaining;
        this.mDelegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.mRemaining > 0 && this.mDelegate.hasNext();
    }

    @Override
    public T next() {
        if (this.mRemaining <= 0) {
            throw new NoSuchElementException("Truncation limit already reached");
        }
        --this.mRemaining;
        return this.mDelegate.next();
    }
}

