/*
 * Copyright 2020 dmfs GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dmfs.jems.function.composite;

import org.dmfs.jems.function.Function;
import org.dmfs.jems.generator.Generator;
import org.dmfs.jems.procedure.Procedure;
import org.dmfs.jems.procedure.composite.Composite;


/**
 * @author marten
 */
public final class Processed<Result> implements Function<Generator<? extends Result>, Result>
{
    private final Procedure<? super Result> mProcedure;


    @SafeVarargs
    public Processed(Procedure<? super Result>... procedure)
    {
        this(new Composite<>(procedure));
    }


    public Processed(Procedure<? super Result> procedure) {mProcedure = procedure;}


    @Override
    public Result value(Generator<? extends Result> generator) throws RuntimeException
    {
        Result result = generator.next();
        mProcedure.process(result);
        return result;
    }
}
