/*
 * Copyright 2021 dmfs GmbH
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.dmfs.jems2.single;

import org.dmfs.jems2.Fragile;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Single;


/**
 * {@link Single} and {@link Optional} that delegates to the given {@link Optional} if that is present, otherwise falls back to the provided back-up {@link Single}.
 */
public final class Backed<T> implements Single<T>, Optional<T>
{
    private final Optional<T> mOptional;
    private final Fragile<? extends T, ? extends RuntimeException> mBackUp;


    public Backed(Optional<T> optional, Fragile<? extends T, ? extends RuntimeException> backUp)
    {
        mOptional = optional;
        mBackUp = backUp;
    }


    public Backed(Optional<T> optional, T backUp)
    {
        this(optional, () -> backUp);
    }


    @Override
    public boolean isPresent()
    {
        return true;
    }


    @Override
    public T value()
    {
        return mOptional.isPresent() ? mOptional.value() : mBackUp.value();
    }
}
