/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.iterable;

import java.util.Iterator;

public final class Seq<T>
implements Iterable<T> {
    private final T[] mValues;
    private final int mCount;

    @SafeVarargs
    public Seq(T ... values) {
        this(values.length, values);
    }

    public Seq(int count, T[] values) {
        if (count < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("Count must not be less than 0, was %d", count));
        }
        if (count > values.length) {
            throw new ArrayIndexOutOfBoundsException(String.format("Count must not be higher than the number of values (%d), was %d", values.length, count));
        }
        this.mCount = count;
        this.mValues = values;
    }

    @Override
    public Iterator<T> iterator() {
        return new org.dmfs.jems2.iterator.Seq<T>(this.mCount, this.mValues);
    }
}

