/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.function;

import org.dmfs.jems2.BiFunction;
import org.dmfs.jems2.Function;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Pair;

public final class DiffMap<Left, Right, Result>
implements Function<Pair<? extends Optional<? extends Left>, ? extends Optional<? extends Right>>, Result> {
    private final BiFunction<? super Left, ? super Right, ? extends Result> mLeftRightFunction;
    private final Function<? super Left, ? extends Result> mLeftFunction;
    private final Function<? super Right, ? extends Result> mRightFunction;

    public DiffMap(BiFunction<? super Left, ? super Right, ? extends Result> leftRightFunction, Function<? super Left, ? extends Result> leftFunction, Function<? super Right, ? extends Result> rightFunction) {
        this.mLeftRightFunction = leftRightFunction;
        this.mLeftFunction = leftFunction;
        this.mRightFunction = rightFunction;
    }

    @Override
    public Result value(Pair<? extends Optional<? extends Left>, ? extends Optional<? extends Right>> pair) {
        if (pair.left().isPresent() && pair.right().isPresent()) {
            return this.mLeftRightFunction.value(pair.left().value(), pair.right().value());
        }
        if (pair.left().isPresent()) {
            return this.mLeftFunction.value(pair.left().value());
        }
        if (pair.right().isPresent()) {
            return this.mRightFunction.value(pair.right().value());
        }
        throw new IllegalArgumentException("Both, left and right were absent!");
    }
}

