/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.iterator.BaseIterator;

public final class Sieved<E>
extends BaseIterator<E> {
    private final Iterator<E> mDelagate;
    private final Predicate<? super E> mPredicate;
    private E mNext;
    private boolean mHasNext;

    public Sieved(Predicate<? super E> predicate, Iterator<E> delegate) {
        this.mDelagate = delegate;
        this.mPredicate = predicate;
    }

    @Override
    public final boolean hasNext() {
        return this.moveToNext();
    }

    @Override
    public final E next() {
        if (!this.moveToNext()) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        this.mHasNext = false;
        return this.mNext;
    }

    private boolean moveToNext() {
        if (this.mHasNext) {
            return true;
        }
        while (this.mDelagate.hasNext()) {
            E next = this.mDelagate.next();
            if (!this.mPredicate.satisfiedBy(next)) continue;
            this.mNext = next;
            this.mHasNext = true;
            return true;
        }
        return false;
    }
}

