/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.iterator.BaseIterator;

public final class While<T>
extends BaseIterator<T> {
    private final Predicate<? super T> mPredicate;
    private final Iterator<? extends T> mDelegate;
    public T mNext;
    private boolean mDeterminedNext;
    private boolean mDone;

    public While(Predicate<? super T> predicate, Iterator<? extends T> delegate) {
        this.mPredicate = predicate;
        this.mDelegate = delegate;
    }

    @Override
    public boolean hasNext() {
        return this.moveToNext();
    }

    @Override
    public T next() {
        if (!this.moveToNext()) {
            throw new NoSuchElementException("No more elements to iterate");
        }
        this.mDeterminedNext = false;
        return this.mNext;
    }

    private boolean moveToNext() {
        T next;
        if (this.mDone || this.mDeterminedNext) {
            return !this.mDone;
        }
        if (this.mDelegate.hasNext() && this.mPredicate.satisfiedBy(next = this.mDelegate.next())) {
            this.mNext = next;
            this.mDeterminedNext = true;
            return true;
        }
        this.mDone = true;
        return false;
    }
}

