/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.jems2.function;

import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.Function;

public final class Unchecked<Argument, Result, E extends Exception>
implements Function<Argument, Result> {
    private final Function<? super E, ? extends RuntimeException> mExceptionFunction;
    private final FragileFunction<Argument, Result, E> mDelegate;

    public Unchecked(FragileFunction<Argument, Result, E> delegate) {
        this("Function call failed", delegate);
    }

    public Unchecked(String message, FragileFunction<Argument, Result, E> delegate) {
        this((? super E exception) -> new RuntimeException(message, (Throwable)exception), delegate);
    }

    public Unchecked(Function<? super E, ? extends RuntimeException> exceptionFunction, FragileFunction<Argument, Result, E> delegate) {
        this.mExceptionFunction = exceptionFunction;
        this.mDelegate = delegate;
    }

    @Override
    public Result value(Argument argument) {
        try {
            return this.mDelegate.value(argument);
        }
        catch (Exception e) {
            throw this.mExceptionFunction.value(e);
        }
    }
}

