/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.docbook.xsltng.extensions.PygmentizeCall;
import org.docbook.xsltng.extensions.PygmentizeDefinition;

public class Pygmentize
extends PygmentizeDefinition {
    private final String format = "html";
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "pygmentize");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.OPTIONAL_ITEM, SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new CallPygmentize();
    }

    private class CallPygmentize
    extends PygmentizeCall {
        private CallPygmentize() {
        }

        public Sequence call(XPathContext xpathContext, Sequence[] sequences) throws XPathException {
            Item item;
            this.logger = new DebuggingLogger(xpathContext.getConfiguration().getLogger());
            if (Pygmentize.this.foundPygmentize == null) {
                Pygmentize.this.pygmentize = this.findPygmentize(xpathContext.getConfiguration(), Pygmentize.this.executable, false);
                if (Pygmentize.this.pygmentize == null) {
                    this.logger.debug("pygmentize-errors", "Failed to find pygmentize: " + Pygmentize.this.executable);
                }
            }
            String source = sequences[0].head().getStringValue();
            HashMap<String, String> options = new HashMap<String, String>();
            HashMap<Object, Object> pyoptions = new HashMap();
            if (Pygmentize.this.pygmentize == null) {
                return new StringValue((CharSequence)source);
            }
            if (sequences.length > 1 && (item = sequences[1].head()) != null) {
                if (item instanceof MapItem) {
                    options = this.parseMap((MapItem)item);
                } else {
                    options.put("language", item.getStringValue());
                }
            }
            if (sequences.length > 2 && (item = sequences[2].head()) != null) {
                if (item instanceof MapItem) {
                    pyoptions = this.parseMap((MapItem)item);
                } else {
                    this.logger.error("Third argument to ext:pygmentize is not a map: ignored");
                }
            }
            String language = null;
            if (options.containsKey("language")) {
                language = (String)options.get("language");
            }
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.add(Pygmentize.this.pygmentize);
            cmdline.add("-f");
            cmdline.add("html");
            if (language != null) {
                cmdline.add("-l");
                cmdline.add(language);
            }
            for (String string : pyoptions.keySet()) {
                cmdline.add("-P");
                cmdline.add(string + "=" + (String)pyoptions.get(string));
            }
            if (this.logger.getFlag("pygmentize-show-command")) {
                StringBuilder sb = new StringBuilder();
                for (String s : cmdline) {
                    sb.append(s);
                    sb.append(" ");
                }
                this.logger.debug("pygmentize-show-command", "Pygments: " + sb.toString());
            }
            try {
                String html = this.runPygmentize(cmdline, source);
                if (this.logger.getFlag("pygmentize-show-results")) {
                    this.logger.debug("pygmentize-show-results", "Highlighted: " + html);
                }
                return new StringValue((CharSequence)html);
            }
            catch (IOException ioe) {
                this.logger.warning("Pygments failed: " + ioe.getMessage());
                return new StringValue((CharSequence)source);
            }
        }

        private HashMap<String, String> parseMap(MapItem item) throws XPathException {
            HashMap<String, String> options = new HashMap<String, String>();
            for (KeyValuePair kv : item.keyValuePairs()) {
                options.put(kv.key.getStringValue(), kv.value.getStringValue());
            }
            return options;
        }

        private String runPygmentize(List<String> cmdline, String source) throws IOException {
            ProcessBuilder builder = new ProcessBuilder(cmdline);
            Process process = builder.start();
            OutputStream os = process.getOutputStream();
            PrintStream ps = new PrintStream(os);
            ps.print(source);
            ps.close();
            os.close();
            ProcessOutputReader stdoutReader = new ProcessOutputReader(process.getInputStream());
            ProcessOutputReader stderrReader = new ProcessOutputReader(process.getErrorStream());
            Thread stdoutThread = new Thread(stdoutReader);
            Thread stderrThread = new Thread(stderrReader);
            stdoutThread.start();
            stderrThread.start();
            int rc = 0;
            try {
                rc = process.waitFor();
                stdoutThread.join();
                stderrThread.join();
            }
            catch (InterruptedException tie) {
                throw new RuntimeException(tie);
            }
            String errResult = stderrReader.getResult();
            if (!"".equals(errResult.trim())) {
                this.logger.warning(errResult);
            }
            return stdoutReader.getResult();
        }

        private class ProcessOutputReader
        implements Runnable {
            private InputStream is = null;
            private StringBuilder resultBuilder = null;

            public ProcessOutputReader(InputStream is) {
                this.is = is;
                this.resultBuilder = new StringBuilder();
            }

            public String getResult() {
                return this.resultBuilder.toString();
            }

            @Override
            public void run() {
                try {
                    InputStreamReader r = new InputStreamReader(this.is);
                    char[] buf = new char[4096];
                    int len = r.read(buf, 0, buf.length);
                    while (len >= 0) {
                        if (len == 0) {
                            Thread.sleep(1000L);
                            continue;
                        }
                        String s = new String(buf, 0, len);
                        this.resultBuilder.append(s);
                        len = r.read(buf, 0, buf.length);
                    }
                }
                catch (IOException ioe) {
                    System.err.println("Pygments I/O error: " + ioe.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

