/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.xml.transform.Source;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidateRNG
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "validate-with-relax-ng");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_NODE, SequenceType.SINGLE_ITEM, SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new PropertiesCall();
    }

    private boolean getBooleanOption(HashMap<String, String> options, String name, boolean defvalue) {
        if (options.containsKey(name)) {
            String value = options.get(name);
            if ("true".equals(value) || "false".equals(value)) {
                return "true".equals(value);
            }
            if ("1".equals(value) || "0".equals(value)) {
                return "1".equals(value);
            }
            if ("yes".equals(value) || "no".equals(value)) {
                return "yes".equals(value);
            }
            throw new IllegalArgumentException("Boolean option " + name + " cannot be " + value);
        }
        return defvalue;
    }

    private HashMap<String, String> parseMap(MapItem item) throws XPathException {
        HashMap<String, String> options = new HashMap<String, String>();
        for (KeyValuePair kv : item.keyValuePairs()) {
            String key = null;
            if (kv.key.getItemType() != BuiltInAtomicType.STRING) {
                throw new IllegalArgumentException("Option map keys must be strings");
            }
            key = kv.key.getStringValue();
            String value = kv.value.getStringValue();
            options.put(key, value);
        }
        return options;
    }

    class RNGErrorHandler
    implements ErrorHandler {
        SAXParseException error = null;
        XdmArray errors = new XdmArray();

        RNGErrorHandler() {
        }

        public SAXParseException getError() {
            return this.error;
        }

        public XdmArray getErrors() {
            return this.errors;
        }

        private void addError(SAXParseException err, String etype) {
            XdmMap map = new XdmMap();
            map = map.put(new XdmAtomicValue("type"), (XdmValue)new XdmAtomicValue(etype));
            map = map.put(new XdmAtomicValue("error"), (XdmValue)new XdmAtomicValue(err.getMessage()));
            if (err.getLineNumber() > 0) {
                map = map.put(new XdmAtomicValue("line"), (XdmValue)new XdmAtomicValue(err.getLineNumber()));
            }
            if (err.getColumnNumber() > 0) {
                map = map.put(new XdmAtomicValue("column"), (XdmValue)new XdmAtomicValue(err.getColumnNumber()));
            }
            this.errors = this.errors.addMember((XdmValue)map);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addError(exception, "warning");
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addError(exception, "error");
            if (this.error == null) {
                this.error = exception;
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(exception, "fatal-error");
            this.error = exception;
        }
    }

    private class PropertiesCall
    extends ExtensionFunctionCall {
        private PropertiesCall() {
        }

        public Sequence call(XPathContext context, Sequence[] sequences) throws XPathException {
            NodeInfo source = (NodeInfo)sequences[0].head();
            HashMap options = new HashMap();
            NodeInfo schema = null;
            String schemaFile = null;
            Item item = null;
            if (sequences.length > 2 && (item = sequences[2].head()) != null) {
                if (item instanceof MapItem) {
                    options = ValidateRNG.this.parseMap((MapItem)item);
                } else {
                    throw new IllegalArgumentException("ext:validate-with-relax-ng options must be a map");
                }
            }
            if ((item = sequences[1].head()) instanceof StringValue) {
                schemaFile = item.getStringValue();
            } else if (item instanceof NodeInfo) {
                schema = (NodeInfo)item;
            } else {
                throw new IllegalArgumentException("ext:validate-with-relax-ng invalid schema");
            }
            boolean assertValid = ValidateRNG.this.getBooleanOption(options, "assert-valid", true);
            boolean dtdCompatibility = ValidateRNG.this.getBooleanOption(options, "dtd-compatibility", false);
            boolean valid = false;
            RNGErrorHandler handler = new RNGErrorHandler();
            try {
                VerifierFactory factory = VerifierFactory.newInstance((String)"http://relaxng.org/ns/structure/1.0");
                Processor processor = (Processor)context.getConfiguration().getProcessor();
                Schema docSchema = null;
                CharArrayWriter writer = null;
                Serializer serializer = null;
                ByteArrayInputStream istream = null;
                if (schema == null) {
                    try {
                        URL usource = new URL(schemaFile);
                        docSchema = factory.compileSchema(usource.openStream());
                    }
                    catch (MalformedURLException mue) {
                        docSchema = factory.compileSchema(new File(schemaFile));
                    }
                } else {
                    writer = new CharArrayWriter();
                    serializer = processor.newSerializer();
                    serializer.setOutputWriter((Writer)writer);
                    serializer.serialize((Source)schema);
                    istream = new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
                    docSchema = factory.compileSchema((InputStream)istream, schema.getBaseURI());
                }
                writer = new CharArrayWriter();
                serializer = processor.newSerializer();
                serializer.setOutputWriter((Writer)writer);
                serializer.serialize((Source)source);
                istream = new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
                InputSource docSource = new InputSource(istream);
                Verifier verifier = docSchema.newVerifier();
                verifier.setErrorHandler((ErrorHandler)handler);
                valid = verifier.verify(docSource);
            }
            catch (IOException | SaxonApiException | VerifierConfigurationException | SAXException vce) {
                throw new RuntimeException(vce);
            }
            if (!valid && assertValid) {
                throw new RuntimeException("Invalid document: " + handler.getError().getMessage());
            }
            XdmMap map = new XdmMap();
            map = map.put(new XdmAtomicValue("valid"), (XdmValue)new XdmAtomicValue(valid));
            map = map.put(new XdmAtomicValue("document"), (XdmValue)new XdmNode(source));
            if (!valid) {
                map = map.put(new XdmAtomicValue("errors"), (XdmValue)handler.getErrors());
            }
            return map.getUnderlyingValue();
        }
    }
}

