/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.xml.sax.InputSource;

public abstract class ImageCall
extends ExtensionFunctionCall {
    private static final String svgNamespace = "http://www.w3.org/2000/svg";
    protected DebuggingLogger logger = null;
    protected XPathContext context = null;
    protected XdmMap map = new XdmMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseImage(String imageUri) {
        InputStream stream = null;
        try {
            URL url = new URL(imageUri);
            stream = url.openStream();
            BufferedReader ir = new BufferedReader(new InputStreamReader(stream));
            String line = ir.readLine();
            if (line != null && line.startsWith("%PDF-")) {
                int lineLimit = 100;
                while (lineLimit > 0 && line != null) {
                    --lineLimit;
                    if (line.startsWith("/CropBox [")) {
                        if ((line = line.substring(10)).contains("]")) {
                            line = line.substring(0, line.indexOf("]"));
                        }
                        this.map = this.parseBox(this.map, line);
                        lineLimit = 0;
                    } else if (line.startsWith("/MediaBox [")) {
                        if ((line = line.substring(11)).contains("]")) {
                            line = line.substring(0, line.indexOf("]"));
                        }
                        this.map = this.parseBox(this.map, line);
                    }
                    line = ir.readLine();
                }
            } else if (line != null && (line.startsWith("<?xml") || line.startsWith("<!DOCTYPE") || line.startsWith("<svg"))) {
                this.map = this.parseSvg(this.map, imageUri);
            } else {
                this.logger.info("DocBook image properties failed to interpret: " + imageUri);
            }
        }
        catch (Exception e) {
            this.logger.info("DocBook image properties failed to load image: " + imageUri);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected XdmMap parseProperty(XdmMap map, String name, String value) {
        return this.parseProperty(map, name, value, -1);
    }

    protected XdmMap parseProperty(XdmMap map, String name, String value, int tagType) {
        this.logger.debug("image-properties", "Parsing image property: (" + tagType + ") " + name + "=" + value);
        if (tagType == 1668313716) {
            name = "profile-copyright";
        }
        switch (name) {
            case "bounding-box": {
                map = map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(value));
                map = this.parseBox(map, value);
                break;
            }
            case "image-width": {
                try {
                    int width = Integer.parseInt(value);
                    map = map.put(new XdmAtomicValue("width"), (XdmValue)new XdmAtomicValue(width));
                    map = map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(width));
                }
                catch (NumberFormatException nfe) {
                    map = map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(value));
                }
                break;
            }
            case "image-height": {
                try {
                    int height = Integer.parseInt(value);
                    map = map.put(new XdmAtomicValue("height"), (XdmValue)new XdmAtomicValue(height));
                    map = map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(height));
                }
                catch (NumberFormatException nfe) {
                    map = map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(value));
                }
                break;
            }
            case "width": {
                try {
                    int width = Integer.parseInt(value);
                    map = map.put(new XdmAtomicValue("width"), (XdmValue)new XdmAtomicValue(width));
                }
                catch (NumberFormatException width) {}
                break;
            }
            case "height": {
                try {
                    int height = Integer.parseInt(value);
                    map = map.put(new XdmAtomicValue("height"), (XdmValue)new XdmAtomicValue(height));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            default: {
                map = value.matches("^[-+]?\\d+$") ? map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(Integer.parseInt(value))) : (value.matches("^[-+]\\d+\\.\\d+$") ? map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(Double.parseDouble(value))) : map.put(new XdmAtomicValue(name), (XdmValue)new XdmAtomicValue(value)));
            }
        }
        return map;
    }

    private XdmMap parseBox(XdmMap map, String line) {
        int[] corners = new int[4];
        int count = 0;
        boolean ok = true;
        StringTokenizer st = new StringTokenizer(line);
        while (count < 4 && st.hasMoreTokens()) {
            try {
                corners[count++] = Integer.parseInt(st.nextToken());
            }
            catch (Exception e) {
                ok = false;
            }
        }
        if (ok && count == 4) {
            map = map.put(new XdmAtomicValue("width"), (XdmValue)new XdmAtomicValue(corners[2] - corners[0]));
            map = map.put(new XdmAtomicValue("height"), (XdmValue)new XdmAtomicValue(corners[3] - corners[1]));
        }
        return map;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private XdmMap parseSvg(XdmMap map, String url) {
        Configuration.ApiProvider api = this.context.getConfiguration().getProcessor();
        if (api instanceof Processor) {
            try {
                DocumentBuilder builder = ((Processor)api).newDocumentBuilder();
                builder.setDTDValidation(false);
                XdmNode doc = builder.build((Source)new SAXSource(new InputSource(url)));
                XdmNode root = null;
                XdmSequenceIterator it = doc.axisIterator(Axis.CHILD);
                while (root == null && it.hasNext()) {
                    XdmNode node = (XdmNode)it.next();
                    if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    root = node;
                }
                if (root == null || !svgNamespace.equals(root.getNodeName().getNamespaceURI())) return map;
                it = root.axisIterator(Axis.ATTRIBUTE);
                while (it.hasNext()) {
                    XdmNode attr = (XdmNode)it.next();
                    String name = attr.getNodeName().getClarkName();
                    String value = attr.getStringValue();
                    map = this.parseProperty(map, name, value);
                }
                return map;
            }
            catch (SaxonApiException sae) {
                this.logger.info("DocBook image properties failed to parse SVG: " + url);
                return map;
            }
        } else {
            this.logger.debug("image-errors", "DocBook image properties failed to find processor to parse SVG");
        }
        return map;
    }
}

