/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.docbook.xsltng.extensions.ImageCall;

public class ImageMetadata
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "image-metadata");
    private static final String[] controls = new String[]{"0000", "0001", "0002", "0003", "0004", "0005", "0006", "0007", "0008", "000b", "000c", "000e", "000f", "0010", "0011", "0012", "0013", "0014", "0015", "0016", "0017", "0018", "0019", "001a", "001b", "001c", "001d", "001e", "001f", "007c"};

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new PropertiesCall();
    }

    private class PropertiesCall
    extends ImageCall {
        private PropertiesCall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Sequence call(XPathContext xpathContext, Sequence[] sequences) throws XPathException {
            this.context = xpathContext;
            this.logger = new DebuggingLogger(xpathContext.getConfiguration().getLogger());
            String imageUri = sequences[0].head().getStringValue();
            InputStream stream = null;
            try {
                URL url = new URL(imageUri);
                stream = url.openStream();
                Metadata metadata = ImageMetadataReader.readMetadata((InputStream)stream);
                for (Directory directory : metadata.getDirectories()) {
                    for (Tag tag : directory.getTags()) {
                        String name = tag.getTagName().toLowerCase();
                        name = name.replace(" ", "-");
                        String value = tag.getDescription();
                        value = value.replaceAll("\\\\u([0-9a-fA-F]{4}+)", "\\\\u005cu$1");
                        for (String control : controls) {
                            String match = "^.*\\\\u" + control + ".*$";
                            if (!value.matches(match)) continue;
                            value = value.replaceAll("[\\\\u" + control + "]", "\\\\u" + control);
                        }
                        if (value.matches("^\\d\\d\\d\\d:\\d\\d:\\d\\d \\d\\d:\\d\\d:\\d\\d$")) {
                            value = value.substring(0, 4) + "-" + value.substring(5, 7) + "-" + value.substring(8, 10) + "T" + value.substring(11, 19);
                        }
                        this.map = this.parseProperty(this.map, name, value, tag.getTagType());
                    }
                }
                MapItem mapItem = this.map.getUnderlyingValue();
                return mapItem;
            }
            catch (IOException ioe) {
                this.logger.info("ext:image-metadata unreadable: " + imageUri);
                MapItem mapItem = this.map.getUnderlyingValue();
                return mapItem;
            }
            catch (ImageProcessingException imageProcessingException) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.parseImage(imageUri);
            return this.map.getUnderlyingValue();
        }
    }
}

