/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Metadata;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Initializer;
import org.docbook.xsltng.extensions.Cwd;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.docbook.xsltng.extensions.ImageMetadata;
import org.docbook.xsltng.extensions.ImageProperties;
import org.docbook.xsltng.extensions.Pygmentize;
import org.docbook.xsltng.extensions.PygmentizeAvailable;
import org.docbook.xsltng.extensions.ValidateRNG;
import org.docbook.xsltng.extensions.XInclude;

public class Register
implements Initializer {
    public void initialize(Configuration config) {
        DebuggingLogger logger = new DebuggingLogger(config.getLogger());
        logger.debug("registration", "Registering DocBook xslTNG extension functions (version 1.11.0)");
        config.registerExtensionFunction((ExtensionFunctionDefinition)new Cwd());
        config.registerExtensionFunction((ExtensionFunctionDefinition)new ImageProperties());
        try {
            String gif1x1 = "R0lGODlhAQABAPAAAP///wAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==";
            byte[] decoded = Base64.getDecoder().decode(gif1x1);
            ByteArrayInputStream stream = new ByteArrayInputStream(decoded);
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)stream);
            if (metadata != null) {
                config.registerExtensionFunction((ExtensionFunctionDefinition)new ImageMetadata());
            }
        }
        catch (Exception e) {
            logger.debug("registration", "DocBook xslTNG extension function ext:image-metadata unavailable");
        }
        config.registerExtensionFunction((ExtensionFunctionDefinition)new Pygmentize());
        config.registerExtensionFunction((ExtensionFunctionDefinition)new PygmentizeAvailable());
        config.registerExtensionFunction((ExtensionFunctionDefinition)new XInclude());
        config.registerExtensionFunction((ExtensionFunctionDefinition)new ValidateRNG());
    }
}

