/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Transform;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.CommandLineOptions;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.xml.sax.InputSource;

public class Main
extends Transform {
    Vector<String> userArgs = new Vector();
    private Vector<String> userCatalogFiles = new Vector();
    private boolean userStylesheet = false;
    private boolean uriResolver = false;
    private boolean sourceReader = false;
    private boolean stylesheetReader = false;
    private boolean init = false;
    protected Processor processor = null;
    protected DebuggingLogger logger = null;
    protected String version = null;
    protected String jarLoc = null;
    protected String catalogFile = null;
    protected Properties configProperties = null;

    public static void main(String[] args) {
        Main instance = new Main(args);
        instance.run();
    }

    public Main(String[] args) {
        int pos = 0;
        for (String arg : args) {
            if (arg.startsWith("-catalog:")) {
                pos = arg.indexOf(":");
                this.userCatalogFiles.add(arg.substring(pos + 1));
                continue;
            }
            this.uriResolver = this.uriResolver || arg.startsWith("-r:");
            this.sourceReader = this.sourceReader || arg.startsWith("-x:");
            this.stylesheetReader = this.stylesheetReader || arg.startsWith("-y:");
            this.userStylesheet = this.userStylesheet || arg.startsWith("-xsl:");
            this.init = this.init || arg.startsWith("-init:");
            this.userArgs.add(arg);
        }
        this.processor = new Processor(false);
        this.logger = new DebuggingLogger(this.processor.getUnderlyingConfiguration().getLogger());
        this.findJarLocation();
        this.logger.debug("main", "jarLoc=" + this.jarLoc);
        this.createCatalog(System.getProperty("org.docbook.xsltng.catalog-file"));
        this.run();
    }

    public void findJarLocation() {
        CodeSource src = Main.class.getProtectionDomain().getCodeSource();
        String classLoc = src.getLocation().toString();
        this.logger.debug("main", "classLoc=" + classLoc);
        if (classLoc.endsWith(".jar")) {
            this.jarLoc = "jar:" + classLoc + "!";
        } else if (classLoc.indexOf("/build/") > 0) {
            this.jarLoc = classLoc + "../../../stage/jar";
            try {
                this.loadProperties();
            }
            catch (UnsupportedOperationException e) {
                this.logger.warning("Jar location incomplete: " + this.jarLoc);
            }
        } else {
            throw new RuntimeException("org.docbook.xsltng.Main cannot find root from " + classLoc);
        }
    }

    public void run() {
        if (this.uriResolver || this.sourceReader || this.stylesheetReader || this.init) {
            if (this.uriResolver) {
                this.logger.error("The -r: option is not supported");
            }
            if (this.sourceReader) {
                this.logger.error("The -x: option is not supported");
            }
            if (this.stylesheetReader) {
                this.logger.error("The -y: option is not supported");
            }
            if (this.init) {
                this.logger.error("The -init: option is not supported");
            }
            System.exit(1);
        }
        StringBuilder catBuilder = new StringBuilder();
        catBuilder.append(this.catalogFile);
        for (String cat : this.userCatalogFiles) {
            catBuilder.append(";");
            catBuilder.append(cat);
        }
        System.setProperty("xml.catalog.files", catBuilder.toString());
        this.userArgs.add("-x:org.xmlresolver.tools.ResolvingXMLReader");
        this.userArgs.add("-y:org.xmlresolver.tools.ResolvingXMLReader");
        this.userArgs.add("-r:org.xmlresolver.Resolver");
        this.userArgs.add("-init:org.docbook.xsltng.extensions.Register");
        if (!this.userStylesheet) {
            this.userArgs.add("-xsl:https://cdn.docbook.org/release/xsltng/current/xslt/docbook.xsl");
        }
        String[] args = new String[this.userArgs.size()];
        this.userArgs.toArray(args);
        if (this.logger.getFlag("java-args")) {
            this.logger.debug("java-args", "xml.catalog.files=" + System.getProperty("xml.catalog.files"));
            for (String arg : args) {
                this.logger.debug("java-args", arg);
            }
        }
        this.doTransform(args, "java org.docbook.xsltng.Main");
        System.exit(0);
    }

    public String createCatalog(String catalogFilename) {
        if (this.catalogFile != null && (catalogFilename == null || this.catalogFile.equals(catalogFilename))) {
            return this.catalogFile;
        }
        try {
            Processor processor = new Processor(false);
            DocumentBuilder builder = processor.newDocumentBuilder();
            builder.setDTDValidation(false);
            builder.setLineNumbering(true);
            URL uris_url = new URL(this.jarLoc + "/etc/uris.xml");
            URL xsl_url = new URL(this.jarLoc + "/etc/make-catalog.xsl");
            InputSource uris_src = new InputSource(this.getStream(uris_url));
            InputSource xsl_src = new InputSource(this.getStream(xsl_url));
            uris_src.setSystemId(uris_url.toURI().toASCIIString());
            xsl_src.setSystemId(xsl_url.toURI().toASCIIString());
            XdmNode uris = builder.build((Source)new SAXSource(uris_src));
            XdmNode xsl = builder.build((Source)new SAXSource(xsl_src));
            XsltCompiler compiler = processor.newXsltCompiler();
            compiler.setSchemaAware(false);
            XsltExecutable exec = compiler.compile(xsl.asSource());
            XsltTransformer transformer = exec.load();
            transformer.setParameter(new QName("", "jarloc"), (XdmValue)new XdmAtomicValue(this.jarLoc));
            transformer.setParameter(new QName("", "version"), (XdmValue)new XdmAtomicValue(this.version()));
            transformer.setInitialContextNode(uris);
            XdmDestination xresult = new XdmDestination();
            transformer.setDestination((Destination)xresult);
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.transform();
            XdmNode xformed = xresult.getXdmNode();
            File tempcat = null;
            if (catalogFilename == null) {
                tempcat = File.createTempFile("dbcat", ".xml");
                tempcat.deleteOnExit();
            } else {
                tempcat = new File(catalogFilename);
            }
            this.logger.debug("main", "Transient catalog file: " + tempcat.getAbsolutePath());
            PrintStream catstream = new PrintStream(tempcat);
            catstream.print(xformed.toString());
            catstream.close();
            this.catalogFile = tempcat.getAbsolutePath();
            return this.catalogFile;
        }
        catch (IOException | URISyntaxException | SaxonApiException sae) {
            this.logger.info("org.docbook.XSLT20 failed to create catalog: " + sae.getMessage());
            throw new RuntimeException(sae);
        }
    }

    protected InputStream getStream(URL url) {
        URLConnection conn = null;
        try {
            try {
                conn = (JarURLConnection)url.openConnection();
            }
            catch (ClassCastException cce) {
                conn = url.openConnection();
            }
            return conn.getInputStream();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Cannot read: " + url.toString());
        }
    }

    protected String version() {
        if (this.version != null) {
            return this.version;
        }
        this.loadProperties();
        this.version = this.configProperties.getProperty("version");
        if (this.version == null) {
            throw new UnsupportedOperationException("No version property in version.properties!?");
        }
        return this.version;
    }

    private void loadProperties() {
        if (this.configProperties != null) {
            return;
        }
        this.configProperties = new Properties();
        InputStream stream = null;
        try {
            URL version_url = new URL(this.jarLoc + "/etc/version.properties");
            stream = this.getStream(version_url);
            this.configProperties.load(stream);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException("Failed to load version.properties file from JAR!?");
        }
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println("DocBook xslTNG wrapper for " + this.getConfiguration().getProductTitle());
        }
        System.err.println("This wrapper accepts the same options as the standard Saxonica command line:");
        System.err.println("(see http://www.saxonica.com/documentation/index.html#!using-xsl/commandline)");
        System.err.println("except that -r, -x, -y, -z, and -init are forbidden. This wrapper specifies");
        System.err.println("values for those options.");
        System.err.println("Format: " + CommandLineOptions.getCommandName((Object)((Object)this)) + " options params");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set stylesheet string parameter");
        System.err.println("  +param=filename       Set stylesheet document parameter");
        System.err.println("  ?param=expression     Set stylesheet parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if (this.allowExit) {
            if ("".equals(message)) {
                System.exit(0);
            } else {
                System.exit(2);
            }
        } else {
            throw new RuntimeException(message);
        }
    }
}

