<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:map="http://www.w3.org/2005/xpath-functions/map"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:x="http://www.jenitennison.com/xslt/xspec"
                exclude-result-prefixes="map xs"
                version="3.0">

<xsl:output method="xml" encoding="utf-8" indent="yes"
            omit-xml-declaration="yes"/>

<!-- This is a first pass at picking out the "ordinary" inlines.
     These are the elements for which tests can be generated.
     Some inlines, like anchor and xref, have special semantics
     so those tests are maintained by hand. The map connects
     DocBook elements to the inline element they generate
-->
<xsl:variable name="inline-map" select="map {
  'abbrev': 'span',
  'accel': 'span',
  'acronym': 'span',
  'application': 'span',
  'buildtarget': 'code',
  'citation': 'span',
  'citebiblioid': 'span',
  'citerefentry': 'span',
  'citetitle': 'i',
  'classname': 'code',
  'command': 'code',
  'computeroutput': 'code',
  'constant': 'code',
  'coref': 'span',
  'database': 'span',
  'date': 'span',
  'editor': 'span',
  'email': 'code',
  'enumidentifier': 'span',
  'enumname': 'code',
  'enumvalue': 'span',
  'envar': 'code',
  'errorcode': 'code',
  'errorname': 'code',
  'errortext': 'span',
  'errortype': 'span',
  'exceptionname': 'code',
  'filename': 'code',
  'firstterm': 'span',
  'foreignphrase': 'span',
  'function': 'code',
  'glossterm': 'span',
  'guibutton': 'span',
  'guiicon': 'span',
  'guilabel': 'span',
  'guimenu': 'span',
  'guimenuitem': 'span',
  'guisubmenu': 'span',
  'hardware': 'span',
  'initializer': 'code',
  'inlinestagedir': 'span',
  'interfacename': 'code',
  'jobtitle': 'span',
  'keycap': 'span',
  'keycode': 'span',
  'keycombo': 'span',
  'keysym': 'span',
  'literal': 'code',
  'macroname': 'code',
  'markup': 'code',
  'medialabel': 'em',
  'menuchoice': 'span',
  'methodname': 'code',
  'modifier': 'code',
  'mousebutton': 'span',
  'namespace': 'span',
  'namespacename': 'code',
  'ooclass': 'span',
  'ooexception': 'span',
  'oointerface': 'span',
  'option': 'code',
  'optional': 'span',
  'org': 'span',
  'orgname': 'span',
  'package': 'code',
  'parameter': 'code',
  'person': 'span',
  'phrase': 'span',
  'productname': 'span',
  'productnumber': 'span',
  'prompt': 'code',
  'property': 'code',
  'replaceable': 'em',
  'returnvalue': 'code',
  'revnumber': 'span',
  'shortcut': 'span',
  'structfield': 'code',
  'symbol': 'span',
  'systemitem': 'code',
  'templateid': 'span',
  'termdef': 'span',
  'token': 'code',
  'trademark': 'span',
  'type': 'code',
  'typedefname': 'code',
  'unionname': 'code',
  'uri': 'code',
  'userinput': 'code',
  'varname': 'code',
  'wordasword': 'em'
}"/>

<xsl:template match="/">
  <x:description xmlns:x="http://www.jenitennison.com/xslt/xspec"
                 xmlns:h="http://www.w3.org/1999/xhtml"
                 stylesheet="../../main/xslt/docbook.xsl">

    <xsl:text>&#10;&#10;</xsl:text>
    <xsl:comment> These tests are generated, do not edit this file by hand. </xsl:comment>
    <xsl:text>&#10;&#10;</xsl:text>

    <xsl:for-each select="map:keys($inline-map)">
      <xsl:sort select="."/>
      <xsl:variable name="inline" select="."/>
      <xsl:variable name="mapping" select="map:get($inline-map, $inline)"/>
      <xsl:variable name="an"
                    select="if (substring($inline, 1, 1) = ('a', 'e', 'i', 'o'))
                            then 'an'
                            else 'a'"/>
      <xsl:variable name="elem" as="element()"><x/></xsl:variable>
      <xsl:variable name="id" select="generate-id($elem)"/>

      <xsl:variable name="text"
                    select="'This is ' || $an || ' ' || $inline || ' element.'"/>

      <x:scenario label="When converting {$an} {$inline} element">
        <x:context xmlns="http://docbook.org/ns/docbook">
          <xsl:element name="{$inline}" namespace="http://docbook.org/ns/docbook">
            <xsl:value-of select="$text"/>
          </xsl:element>
        </x:context>
        <x:expect label="it should return a single {$mapping} element"
                  test="count(/h:body/h:main/*) = 1 and local-name(/h:body/h:main/*[1]) = '{$mapping}' and namespace-uri(/h:body/h:main/*[1]) = 'http://www.w3.org/1999/xhtml'"/>
        <x:expect label="it should return the DocBook name as the class"
                  test="/h:body/h:main/*/@class = '{$inline}'"/>
        <x:expect label="it should not return any other attributes"
                  test="empty(/h:body/h:main/*/@* except /h:body/h:main/*/@class)"/>
        <x:expect label="it should return the correct text"
                  test="/h:body/h:main/*/string() = '{$text}'"/>
      </x:scenario>

      <x:scenario label="When converting {$an} {$inline} element with an xml:id and roles">
        <x:context xmlns="http://docbook.org/ns/docbook">
          <xsl:element name="{$inline}" namespace="http://docbook.org/ns/docbook">
            <xsl:attribute name="xml:id" select="$id"/>
            <xsl:attribute name="role" select="'b a b c'"/>
            <xsl:text>This is </xsl:text>
            <xsl:value-of select="$an"/>
            <xsl:text> </xsl:text>
            <xsl:value-of select="$inline"/>
            <xsl:text> element.</xsl:text>
          </xsl:element>
        </x:context>
        <x:expect label="it should return a single {$mapping} element"
                  test="count(/h:body/h:main/*) = 1 and local-name(/h:body/h:main/*[1]) = '{$mapping}' and namespace-uri(/h:body/h:main/*[1]) = 'http://www.w3.org/1999/xhtml'"/>
        <x:expect label="it should return the xml:id in the id"
                  test="/h:body/h:main/*/@id = '{$id}'"/>
        
        <xsl:variable name="classes" as="xs:string+">
          <xsl:for-each select="($inline, 'a', 'b', 'c')">
            <xsl:sort select="."/>
            <xsl:sequence select="."/>
          </xsl:for-each>
        </xsl:variable>
        <x:expect label="it should return the roles as classes"
                  test="/h:body/h:main/*/@class = '{string-join($classes, ' ')}'"/>
        <x:expect label="it should not return any other attributes"
                  test="empty(/h:body/h:main/*/@* except (/h:body/h:main/*/@id | /h:body/h:main/*/@class))"/>
        <x:expect label="it should return the correct text"
                  test="/h:body/h:main/string() = '{$text}'"/>
      </x:scenario>
    </xsl:for-each>
  </x:description>
</xsl:template>

</xsl:stylesheet>
