<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:x="http://www.jenitennison.com/xslt/xspec"
                exclude-result-prefixes="xs"
                version="2.0">

<xsl:output method="xml" encoding="utf-8" indent="yes"
            omit-xml-declaration="yes"/>

<xsl:template match="/">
  <x:description xmlns:x="http://www.jenitennison.com/xslt/xspec"
                 xmlns:h="http://www.w3.org/1999/xhtml"
                 stylesheet="../xslt/docbook.xsl">

    <xsl:text>&#10;&#10;</xsl:text>
    <xsl:comment> These tests are generated, do not edit this file by hand. </xsl:comment>
    <xsl:text>&#10;&#10;</xsl:text>

    <xsl:for-each select="('raw', 'plain', 'lines')">
      <xsl:variable name="s" select="."/>

      <xsl:for-each select="('address', 'literallayout', 'screen',
                            'synopsis', 'programlisting')">
        <xsl:variable name="n" select="."/>
        <xsl:variable name="elem" as="element()"><x/></xsl:variable>
        <xsl:variable name="id" select="generate-id($elem)"/>

        <x:scenario label="When converting an {$n} in the {$s} style">
          <x:context xmlns="http://docbook.org/ns/docbook">
            <x:param name="style" select="'{$s}'"/>
            <xsl:element name="{$n}" namespace="http://docbook.org/ns/docbook">
              <xsl:attribute name="xml:id" select="$id"/>
              <xsl:attribute name="role" select="'a b c b'"/>
              <xsl:text>...</xsl:text>
            </xsl:element>
          </x:context>
          <x:expect label="it should return a single div element"
                    test="count(/h:body/h:main/*) = 1 and /h:body/h:main/h:div"/>
          <x:expect label="it should return the xml:id in the id"
                    test="/h:body/h:main/h:div/h:pre/@id = '{$id}'"/>

          <xsl:variable name="lang" select="if ($n = 'programlisting')
                                            then ('language-none', 'numbered')
                                            else ()"/>
          <xsl:variable name="classes" as="xs:string+">
            <xsl:for-each select="($n, $lang, 'a', 'b', 'c', 'verbatim')">
              <xsl:sort select="."/>
              <xsl:sequence select="."/>
            </xsl:for-each>
          </xsl:variable>

          <x:expect label="it should return the roles as classes"
                    test="/h:body/h:main/h:div/h:pre/@class = '{string-join($classes, ' ')}'"/>
          <x:expect label="it should not return any other attributes"
                    test="empty(/h:body/h:main/h:div/*/@* except (/h:body/h:main/h:div/*/@id | /h:body/h:main/h:div/*/@class))"/>
        </x:scenario>
      </xsl:for-each>
    </xsl:for-each>
  </x:description>
</xsl:template>

</xsl:stylesheet>
