/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import junit.framework.TestCase;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.RawDestination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.docbook.xsltng.extensions.Cwd;
import org.xml.sax.InputSource;

public class TestCwd
extends TestCase {
    Processor processor = null;

    protected void setUp() {
        this.processor = new Processor(false);
        this.processor.getUnderlyingConfiguration().registerExtensionFunction((ExtensionFunctionDefinition)new Cwd());
    }

    public void testCwd() {
        String stylesheet = "";
        stylesheet = stylesheet + "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'\n";
        stylesheet = stylesheet + "                xmlns:ext='http://docbook.org/extensions/xslt'\n";
        stylesheet = stylesheet + "                version='3.0'>\n\n";
        stylesheet = stylesheet + "<xsl:output method='text' encoding='utf-8'/>\n\n";
        stylesheet = stylesheet + "<xsl:template match='/' name='main'>\n";
        stylesheet = stylesheet + "  <xsl:value-of select=\"ext:cwd()\"/>\n";
        stylesheet = stylesheet + "</xsl:template>\n\n";
        stylesheet = stylesheet + "</xsl:stylesheet>\n";
        ByteArrayInputStream bais = new ByteArrayInputStream(stylesheet.getBytes(StandardCharsets.UTF_8));
        try {
            RawDestination result = new RawDestination();
            XsltCompiler compiler = this.processor.newXsltCompiler();
            XsltExecutable exec = compiler.compile((Source)new SAXSource(new InputSource(bais)));
            XsltTransformer transformer = exec.load();
            transformer.setDestination((Destination)result);
            transformer.setInitialTemplate(new QName("", "main"));
            transformer.transform();
            XdmValue value = result.getXdmValue();
            TestCwd.assertEquals((String)(System.getProperty("user.dir") + "/"), (String)value.toString());
        }
        catch (SaxonApiException sae) {
            sae.printStackTrace();
            TestCase.fail();
        }
    }
}

