/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng;

import java.util.Vector;
import net.sf.saxon.Transform;
import net.sf.saxon.trans.CommandLineOptions;
import org.docbook.xsltng.XslTNG;
import org.docbook.xsltng.extensions.DebuggingLogger;

public class Main
extends Transform {
    Vector<String> userArgs = new Vector();
    private Vector<String> userCatalogFiles = new Vector();
    private boolean userStylesheet = false;
    private boolean uriResolver = false;
    private boolean sourceReader = false;
    private boolean stylesheetReader = false;
    private boolean init = false;
    protected DebuggingLogger logger = null;
    protected String catalogFile = null;
    protected XslTNG xslTNG = null;

    public static void main(String[] args) {
        Main instance = new Main(args);
        instance.run();
    }

    public Main(String[] args) {
        int pos = 0;
        for (String arg : args) {
            if (arg.startsWith("-catalog:")) {
                pos = arg.indexOf(":");
                this.userCatalogFiles.add(arg.substring(pos + 1));
                continue;
            }
            this.uriResolver = this.uriResolver || arg.startsWith("-r:");
            this.sourceReader = this.sourceReader || arg.startsWith("-x:");
            this.stylesheetReader = this.stylesheetReader || arg.startsWith("-y:");
            this.userStylesheet = this.userStylesheet || arg.startsWith("-xsl:");
            this.init = this.init || arg.startsWith("-init:");
            this.userArgs.add(arg);
        }
        this.xslTNG = new XslTNG();
        this.logger = this.xslTNG.logger;
        this.catalogFile = this.xslTNG.createCatalog(System.getProperty("org.docbook.xsltng.catalog-file"));
    }

    public void run() {
        if (this.uriResolver || this.sourceReader || this.stylesheetReader || this.init) {
            if (this.uriResolver) {
                this.logger.error("The -r: option is not supported");
            }
            if (this.sourceReader) {
                this.logger.error("The -x: option is not supported");
            }
            if (this.stylesheetReader) {
                this.logger.error("The -y: option is not supported");
            }
            if (this.init) {
                this.logger.error("The -init: option is not supported");
            }
            System.exit(1);
        }
        StringBuilder catBuilder = new StringBuilder();
        catBuilder.append(this.catalogFile);
        for (String cat : this.userCatalogFiles) {
            catBuilder.append(";");
            catBuilder.append(cat);
        }
        System.setProperty("xml.catalog.files", catBuilder.toString());
        this.userArgs.add("-x:org.xmlresolver.tools.ResolvingXMLReader");
        this.userArgs.add("-y:org.xmlresolver.tools.ResolvingXMLReader");
        this.userArgs.add("-r:org.xmlresolver.Resolver");
        this.userArgs.add("-init:org.docbook.xsltng.extensions.Register");
        if (!this.userStylesheet) {
            this.userArgs.add("-xsl:https://cdn.docbook.org/release/xsltng/current/xslt/docbook.xsl");
        }
        String[] args = new String[this.userArgs.size()];
        this.userArgs.toArray(args);
        if (this.logger.getFlag("java-args")) {
            this.logger.debug("java-args", "xml.catalog.files=" + System.getProperty("xml.catalog.files"));
            for (String arg : args) {
                this.logger.debug("java-args", arg);
            }
        }
        this.doTransform(args, "java org.docbook.xsltng.Main");
        System.exit(0);
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            System.err.println(message);
        }
        if (!this.showTime) {
            System.err.println("DocBook xslTNG wrapper for " + this.getConfiguration().getProductTitle());
        }
        System.err.println("This wrapper accepts the same options as the standard Saxonica command line:");
        System.err.println("(see http://www.saxonica.com/documentation/index.html#!using-xsl/commandline)");
        System.err.println("except that -r, -x, -y, -z, and -init are forbidden. This wrapper specifies");
        System.err.println("values for those options.");
        System.err.println("Format: " + CommandLineOptions.getCommandName((Object)((Object)this)) + " options params");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        System.err.println("Options available:" + options.displayPermittedOptions());
        System.err.println("Use -XYZ:? for details of option XYZ");
        System.err.println("Params: ");
        System.err.println("  param=value           Set stylesheet string parameter");
        System.err.println("  +param=filename       Set stylesheet document parameter");
        System.err.println("  ?param=expression     Set stylesheet parameter using XPath");
        System.err.println("  !param=value          Set serialization parameter");
        if (this.allowExit) {
            if ("".equals(message)) {
                System.exit(0);
            } else {
                System.exit(2);
            }
        } else {
            throw new RuntimeException(message);
        }
    }
}

