/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import com.thaiopensource.resolver.AbstractResolver;
import com.thaiopensource.resolver.BasicResolver;
import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.ResolverException;
import com.thaiopensource.resolver.catalog.ResolverIOException;
import com.thaiopensource.resolver.xml.ExternalDTDSubsetIdentifier;
import com.thaiopensource.resolver.xml.ExternalEntityIdentifier;
import com.thaiopensource.resolver.xml.ExternalIdentifier;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.prop.rng.RngProperty;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlresolver.Resolver;
import org.xmlresolver.XMLResolverConfiguration;
import org.xmlresolver.sources.ResolverInputSource;
import org.xmlresolver.sources.ResolverSAXSource;

public class ValidateRNG
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "validate-with-relax-ng");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 3;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_NODE, SequenceType.SINGLE_ITEM, SequenceType.OPTIONAL_ITEM};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new PropertiesCall();
    }

    private InputSource nodeInfoToInputSource(XPathContext context, NodeInfo source) {
        try {
            Processor processor = (Processor)context.getConfiguration().getProcessor();
            CharArrayWriter writer = new CharArrayWriter();
            Serializer serializer = processor.newSerializer();
            serializer.setOutputWriter((Writer)writer);
            serializer.serialize((Source)source);
            ByteArrayInputStream istream = new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
            return new InputSource(istream);
        }
        catch (SaxonApiException se) {
            throw new IllegalArgumentException(se);
        }
    }

    private boolean getBooleanOption(HashMap<String, String> options, String name, boolean defvalue) {
        if (options.containsKey(name)) {
            String value = options.get(name);
            if ("true".equals(value) || "false".equals(value)) {
                return "true".equals(value);
            }
            if ("1".equals(value) || "0".equals(value)) {
                return "1".equals(value);
            }
            if ("yes".equals(value) || "no".equals(value)) {
                return "yes".equals(value);
            }
            throw new IllegalArgumentException("Boolean option " + name + " cannot be " + value);
        }
        return defvalue;
    }

    private HashMap<String, String> parseMap(MapItem item) throws XPathException {
        HashMap<String, String> options = new HashMap<String, String>();
        for (KeyValuePair kv : item.keyValuePairs()) {
            String key = null;
            if (kv.key.getItemType() != BuiltInAtomicType.STRING) {
                throw new IllegalArgumentException("Option map keys must be strings");
            }
            key = kv.key.getStringValue();
            String value = kv.value.getStringValue();
            options.put(key, value);
        }
        return options;
    }

    class JingResolver
    extends AbstractResolver {
        private final Resolver resolver;

        public JingResolver() {
            XMLResolverConfiguration config = new XMLResolverConfiguration();
            this.resolver = new Resolver(config);
        }

        public void resolve(Identifier id, Input input) throws IOException, ResolverException {
            ExternalEntityIdentifier xid;
            ResolverInputSource resolved;
            if (input.isResolved()) {
                return;
            }
            String absoluteUri = null;
            try {
                absoluteUri = BasicResolver.resolveUri((Identifier)id);
                if (id.getUriReference().equals(absoluteUri)) {
                    absoluteUri = null;
                }
            }
            catch (ResolverException resolverException) {
                // empty catch block
            }
            boolean isExternalIdentifier = id instanceof ExternalIdentifier;
            try {
                if (isExternalIdentifier) {
                    resolved = null;
                    if (absoluteUri != null) {
                        resolved = (ResolverInputSource)this.resolver.resolveEntity(null, absoluteUri);
                    }
                    if (resolved == null) {
                        if (id instanceof ExternalEntityIdentifier) {
                            xid = (ExternalEntityIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.resolveEntity(xid.getEntityName(), xid.getPublicId(), null, xid.getUriReference());
                        } else if (id instanceof ExternalDTDSubsetIdentifier) {
                            xid = (ExternalDTDSubsetIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.getExternalSubset(xid.getDoctypeName(), xid.getUriReference());
                        } else {
                            xid = (ExternalIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.resolveEntity(xid.getPublicId(), xid.getUriReference());
                        }
                    }
                    if (resolved != null) {
                        input.setUri(resolved.getSystemId());
                        input.setByteStream(resolved.getByteStream());
                    }
                } else {
                    resolved = null;
                    if (absoluteUri != null) {
                        resolved = (ResolverSAXSource)this.resolver.resolve(absoluteUri, (String)null);
                    }
                    if (resolved == null) {
                        resolved = (ResolverSAXSource)this.resolver.resolve(id.getUriReference(), null);
                    }
                    if (resolved != null) {
                        input.setUri(resolved.getInputSource().getSystemId());
                        input.setByteStream(resolved.getInputSource().getByteStream());
                    }
                }
            }
            catch (TransformerException | SAXException se) {
                throw new RuntimeException(se);
            }
            catch (ResolverIOException e) {
                throw e.getResolverException();
            }
            try {
                if (isExternalIdentifier) {
                    resolved = null;
                    if (absoluteUri != null) {
                        resolved = (ResolverInputSource)this.resolver.resolveEntity(null, absoluteUri);
                    }
                    if (resolved == null) {
                        if (id instanceof ExternalEntityIdentifier) {
                            xid = (ExternalEntityIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.resolveEntity(xid.getEntityName(), xid.getPublicId(), null, xid.getUriReference());
                        } else if (id instanceof ExternalDTDSubsetIdentifier) {
                            xid = (ExternalDTDSubsetIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.getExternalSubset(xid.getDoctypeName(), xid.getUriReference());
                        } else {
                            xid = (ExternalIdentifier)id;
                            resolved = (ResolverInputSource)this.resolver.resolveEntity(xid.getPublicId(), xid.getUriReference());
                        }
                    }
                    if (resolved != null) {
                        input.setUri(resolved.getSystemId());
                        input.setByteStream(resolved.getByteStream());
                    }
                } else {
                    resolved = null;
                    if (absoluteUri != null) {
                        resolved = (ResolverSAXSource)this.resolver.resolve(absoluteUri, (String)null);
                    }
                    if (resolved == null) {
                        resolved = (ResolverSAXSource)this.resolver.resolve(id.getUriReference(), null);
                    }
                    if (resolved != null) {
                        input.setUri(resolved.getInputSource().getSystemId());
                        input.setByteStream(resolved.getInputSource().getByteStream());
                    }
                }
            }
            catch (TransformerException | SAXException se) {
                throw new RuntimeException(se);
            }
            catch (ResolverIOException e) {
                throw e.getResolverException();
            }
        }

        public void open(Input input) throws IOException, ResolverException {
            URI uri;
            if (!input.isUriDefinitive()) {
                return;
            }
            try {
                uri = new URI(input.getUri());
            }
            catch (URISyntaxException e) {
                throw new ResolverException((Throwable)e);
            }
            if (!uri.isAbsolute()) {
                throw new ResolverException("cannot open relative URI: " + uri);
            }
            URL url = new URL(uri.toASCIIString());
            input.setByteStream(url.openStream());
        }
    }

    static class RNGErrorHandler
    implements ErrorHandler {
        SAXParseException error = null;
        XdmArray errors = new XdmArray();

        RNGErrorHandler() {
        }

        public SAXParseException getError() {
            return this.error;
        }

        public XdmArray getErrors() {
            return this.errors;
        }

        private void addError(SAXParseException err, String etype) {
            XdmMap map = new XdmMap();
            map = map.put(new XdmAtomicValue("type"), (XdmValue)new XdmAtomicValue(etype));
            map = map.put(new XdmAtomicValue("error"), (XdmValue)new XdmAtomicValue(err.getMessage()));
            if (err.getLineNumber() > 0) {
                map = map.put(new XdmAtomicValue("line"), (XdmValue)new XdmAtomicValue(err.getLineNumber()));
            }
            if (err.getColumnNumber() > 0) {
                map = map.put(new XdmAtomicValue("column"), (XdmValue)new XdmAtomicValue(err.getColumnNumber()));
            }
            this.errors = this.errors.addMember((XdmValue)map);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addError(exception, "warning");
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addError(exception, "error");
            if (this.error == null) {
                this.error = exception;
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addError(exception, "fatal-error");
            this.error = exception;
        }
    }

    private class PropertiesCall
    extends ExtensionFunctionCall {
        NodeInfo source = null;
        NodeInfo schema = null;
        String schemaFile = null;
        boolean assertValid = false;
        boolean dtdCompatibility = false;

        private PropertiesCall() {
        }

        public Sequence call(XPathContext context, Sequence[] sequences) throws XPathException {
            this.source = (NodeInfo)sequences[0].head();
            HashMap options = new HashMap();
            Item item = null;
            if (sequences.length > 2 && (item = sequences[2].head()) != null) {
                if (item instanceof MapItem) {
                    options = ValidateRNG.this.parseMap((MapItem)item);
                } else {
                    throw new IllegalArgumentException("ext:validate-with-relax-ng options must be a map");
                }
            }
            if ((item = sequences[1].head()) instanceof StringValue) {
                this.schemaFile = item.getStringValue();
            } else if (item instanceof NodeInfo) {
                this.schema = (NodeInfo)item;
            } else {
                throw new IllegalArgumentException("ext:validate-with-relax-ng invalid schema");
            }
            this.assertValid = ValidateRNG.this.getBooleanOption(options, "assert-valid", true);
            this.dtdCompatibility = ValidateRNG.this.getBooleanOption(options, "dtd-compatibility", false);
            XdmMap map = this.jingValid(context);
            return map.getUnderlyingValue();
        }

        private XdmMap jingValid(XPathContext context) {
            boolean valid = false;
            RNGErrorHandler handler = new RNGErrorHandler();
            PropertyMapBuilder properties = new PropertyMapBuilder();
            properties.put(ValidateProperty.ERROR_HANDLER, (Object)handler);
            RngProperty.CHECK_ID_IDREF.add(properties);
            if (!this.dtdCompatibility) {
                properties.put((PropertyId)RngProperty.CHECK_ID_IDREF, null);
            }
            JingResolver resolver = new JingResolver();
            properties.put(ValidateProperty.RESOLVER, (Object)resolver);
            SchemaReader sr = null;
            try {
                ValidationDriver driver = new ValidationDriver(properties.toPropertyMap(), properties.toPropertyMap(), sr);
                InputSource insrc = null;
                insrc = this.schema == null ? ValidationDriver.uriOrFileInputSource((String)this.schemaFile) : ValidateRNG.this.nodeInfoToInputSource(context, this.schema);
                boolean loaded = driver.loadSchema(insrc);
                if (!loaded) {
                    throw new IllegalArgumentException("Failed to load schema");
                }
                insrc = ValidateRNG.this.nodeInfoToInputSource(context, this.source);
                valid = driver.validate(insrc);
            }
            catch (IOException | SAXException ioe) {
                throw new IllegalArgumentException(ioe);
            }
            if (!valid && this.assertValid) {
                throw new RuntimeException("Invalid document: " + handler.getError().getMessage());
            }
            XdmMap map = new XdmMap();
            map = map.put(new XdmAtomicValue("valid"), (XdmValue)new XdmAtomicValue(valid));
            map = map.put(new XdmAtomicValue("document"), (XdmValue)new XdmNode(this.source));
            if (!valid) {
                map = map.put(new XdmAtomicValue("errors"), (XdmValue)handler.getErrors());
            }
            return map;
        }
    }
}

