/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import org.docbook.xsltng.extensions.DebuggingLogger;
import org.docbook.xsltng.extensions.ImageCall;

public class ImageProperties
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "image-properties");
    private static final Pattern dimPatn = Pattern.compile("^(\\d+(\\.\\d*)?)(.*)$");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ITEM;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new PropertiesCall();
    }

    private class PropertiesCall
    extends ImageCall
    implements ImageObserver {
        boolean imageLoaded = false;
        boolean imageFailed = false;
        Image image = null;
        int width = -1;
        int depth = -1;

        private PropertiesCall() {
        }

        public Sequence call(XPathContext xpathContext, Sequence[] sequences) throws XPathException {
            this.context = xpathContext;
            this.logger = new DebuggingLogger(xpathContext.getConfiguration().getLogger());
            String imageFn = sequences[0].head().getStringValue();
            this.imageLoaded = false;
            this.imageFailed = false;
            this.image = null;
            System.setProperty("java.awt.headless", "true");
            try {
                File imageFile = new File(imageFn);
                URL url = imageFile.exists() ? imageFile.toURI().toURL() : new URL(imageFn);
                this.image = Toolkit.getDefaultToolkit().getImage(url);
            }
            catch (MalformedURLException mue) {
                this.image = Toolkit.getDefaultToolkit().getImage(imageFn);
            }
            this.width = this.image.getWidth(this);
            this.depth = this.image.getHeight(this);
            while (!(this.imageFailed || this.width != -1 && this.depth != -1)) {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.width = this.image.getWidth(this);
                this.depth = this.image.getHeight(this);
            }
            this.image.flush();
            if (this.width >= 0 && this.depth >= 0) {
                this.map = this.map.put(new XdmAtomicValue("width"), (XdmValue)new XdmAtomicValue(this.width));
                this.map = this.map.put(new XdmAtomicValue("height"), (XdmValue)new XdmAtomicValue(this.depth));
            }
            if ((this.width == -1 || this.depth == -1) && this.imageFailed) {
                this.parseImage(imageFn);
            }
            return this.map.getUnderlyingValue();
        }

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x40) == 64 || (infoflags & 0x80) == 128) {
                this.imageFailed = true;
                return false;
            }
            return (infoflags & 0x20) != 32;
        }
    }
}

