/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.SequenceType;

public class Cwd
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://docbook.org/extensions/xslt", "cwd");

    public StructuredQName getFunctionQName() {
        return qName;
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 0;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.OPTIONAL_NUMERIC};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_ATOMIC;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new CwdCall();
    }

    private class CwdCall
    extends ExtensionFunctionCall {
        private CwdCall() {
        }

        public Sequence call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            String dir = System.getProperty("user.dir").replace("\\", "/");
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            if (dir.length() > 2 && dir.charAt(1) == ':') {
                dir = dir.substring(2);
            }
            if (dir.startsWith("/")) {
                return new AnyURIValue("file:" + dir);
            }
            return new AnyURIValue("file:/" + dir);
        }
    }
}

