/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.util.HashSet;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;

public class DebuggingLogger
extends StandardLogger {
    public static final String REGISTRATION = "registration";
    public static final String IMAGE_PROPERTIES = "image-properties";
    public static final String IMAGE_ERRORS = "image-errors";
    public static final String PYGMENTIZE_SHOW_COMMAND = "pygmentize-show-command";
    public static final String PYGMENTIZE_SHOW_RESULTS = "pygmentize-show-results";
    public static final String PYGMENTIZE_ERRORS = "pygmentize-errors";
    private static final String propertyName = "org.docbook.xsltng.verbose";
    private Logger logger = null;
    private boolean noisy = false;
    private HashSet<String> flags = new HashSet();

    public DebuggingLogger(Logger logger) {
        this.logger = logger;
        if (System.getProperty(propertyName) != null) {
            String val = System.getProperty(propertyName);
            if ("1".equals(val) || "yes".equals(val) || "true".equals(val)) {
                this.noisy = true;
            } else if (!("0".equals(val) || "no".equals(val) || "false".equals(val))) {
                this.noisy = false;
            } else {
                String[] tokens;
                for (String token : tokens = System.getProperty(propertyName).split("[,\\s]+")) {
                    String flag = token.trim().toLowerCase();
                    if ("".equals(flag)) continue;
                    this.flags.add(flag);
                }
            }
        }
    }

    public boolean getFlag(String flag) {
        return this.noisy || this.flags.contains(flag);
    }

    public void setFlag(String flag) {
        if ("1".equals(flag) || "yes".equals(flag) || "true".equals(flag)) {
            this.noisy = true;
        } else {
            this.flags.add(flag);
        }
    }

    public boolean unsetFlag(String flag) {
        if ("1".equals(flag) || "yes".equals(flag) || "true".equals(flag)) {
            boolean wasNoisy = this.noisy;
            this.noisy = false;
            return wasNoisy;
        }
        return this.flags.remove(flag);
    }

    public void debug(String flag, String message) {
        if ((this.flags.contains(flag) || this.noisy) && this.logger != null) {
            this.logger.info(message);
        }
    }
}

