/*
 * Decompiled with CFR 0.152.
 */
package org.docbook.xsltng.extensions;

import java.io.File;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionCall;
import org.docbook.xsltng.extensions.DebuggingLogger;

public abstract class PygmentizeCall
extends ExtensionFunctionCall {
    public static final String PYGMENTIZE = "org.docbook.xsltng.extensions.pygmentize";
    protected DebuggingLogger logger = null;

    public String findPygmentize(Configuration config, String executable, boolean noisy) {
        String[] paths;
        String pygmentize = null;
        if (System.getProperty(PYGMENTIZE) != null) {
            File pexec = new File(System.getProperty(PYGMENTIZE));
            if (pexec.exists() && pexec.canExecute()) {
                pygmentize = pexec.getAbsolutePath();
                this.message("Using pygmentize: " + pygmentize, noisy);
                return pygmentize;
            }
            this.message("Cannot use pygmentize: " + System.getProperty(PYGMENTIZE), noisy);
            return null;
        }
        this.message("Searching for pygmentize", noisy);
        String pathEnv = System.getenv("PATH");
        if (pathEnv == null) {
            pathEnv = System.getenv("Path");
        }
        for (String path : paths = pathEnv == null ? new String[]{} : pathEnv.split(File.pathSeparator)) {
            File pexec;
            if (pygmentize != null || "".equals(path) || !(pexec = new File(path + File.separatorChar + executable)).exists() || !pexec.canExecute()) continue;
            pygmentize = pexec.getAbsolutePath();
        }
        if (pygmentize == null) {
            this.message("Failed to find pygmentize: " + executable, noisy);
            for (String path : paths) {
                this.message("Not in: " + path, noisy);
            }
        } else {
            this.message("Found pygmentize: " + pygmentize, noisy);
        }
        return pygmentize;
    }

    private void message(String message, boolean noisy) {
        if (noisy && this.logger != null) {
            this.logger.debug("pygmentize-errors", message);
        }
    }
}

