/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.wml.Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mapper {
    protected static Logger log = LoggerFactory.getLogger(Mapper.class);
    protected ConcurrentHashMap<String, PhysicalFont> regularForms = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, PhysicalFont> boldForms = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, PhysicalFont> italicForms = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, PhysicalFont> boldItalicForms = new ConcurrentHashMap();
    protected static final Map<String, PhysicalFont> fontMappings = Collections.synchronizedMap(new HashMap());
    public static final String FONT_FALLBACK = "Times New Roman";

    @Deprecated
    public Map<String, PhysicalFont> getFontMappings() {
        return fontMappings;
    }

    public PhysicalFont get(String key) {
        return fontMappings.get(key.toLowerCase());
    }

    public void put(String key, PhysicalFont pf) {
        PhysicalFont priorPf = fontMappings.get(key.toLowerCase());
        if (priorPf != null) {
            if (priorPf == pf) {
                return;
            }
            log.warn("Overwriting existing fontMapping: " + key.toLowerCase());
        }
        fontMappings.put(key.toLowerCase(), pf);
    }

    public int size() {
        return fontMappings.size();
    }

    public abstract void populateFontMappings(Set<String> var1, Fonts var2) throws Exception;

    public static String getSubstituteFontXsltExtension(Mapper s2, String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        return s2.getSubstituteFontXsltExtension(documentStyleId, bolditalic, fontFamilyStack);
    }

    public String getSubstituteFontXsltExtension(String documentStyleId, String bolditalic, boolean fontFamilyStack) {
        log.debug("Trying to insert HTML font-family value for " + documentStyleId);
        if (documentStyleId == null) {
            log.error("passed null documentStyleId");
            return "nullInputToExtension";
        }
        PhysicalFont physicalFont = this.get(documentStyleId);
        if (physicalFont == null) {
            log.error("No mapping for: " + documentStyleId);
            return FONT_FALLBACK;
        }
        String fontFamily = physicalFont.getName();
        if (fontFamily.startsWith("Britannic")) {
            return fontFamily;
        }
        if (fontFamily.endsWith(" Demibold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 9);
        }
        if (fontFamily.endsWith(" Oblique")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 8);
        }
        if (fontFamily.endsWith(" Italic")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 7);
        }
        if (fontFamily.endsWith(" Bold")) {
            fontFamily = fontFamily.substring(0, fontFamily.length() - 5);
        }
        log.debug("Mapping " + documentStyleId + " to " + physicalFont.getName());
        return fontFamily;
    }

    public void registerRegularForm(String fontNameAsInFontTablePart, PhysicalFont pfRegular) {
        if (pfRegular == null) {
            this.regularForms.remove(fontNameAsInFontTablePart);
        } else {
            this.regularForms.put(fontNameAsInFontTablePart, pfRegular);
        }
    }

    public void registerBoldForm(String fontNameAsInFontTablePart, PhysicalFont pfBold) {
        if (pfBold == null) {
            this.boldForms.remove(fontNameAsInFontTablePart);
        } else {
            this.boldForms.put(fontNameAsInFontTablePart, pfBold);
        }
    }

    public void registerItalicForm(String fontNameAsInFontTablePart, PhysicalFont pfItalic) {
        if (pfItalic == null) {
            this.italicForms.remove(fontNameAsInFontTablePart);
        } else {
            this.italicForms.put(fontNameAsInFontTablePart, pfItalic);
        }
    }

    public void registerBoldItalicForm(String fontNameAsInFontTablePart, PhysicalFont pfBoldItalic) {
        if (pfBoldItalic == null) {
            this.boldItalicForms.remove(fontNameAsInFontTablePart);
        } else {
            this.boldItalicForms.put(fontNameAsInFontTablePart, pfBoldItalic);
        }
    }

    public PhysicalFont getRegularForm(String fontNameAsInFontTablePart) {
        PhysicalFont pfRegular = PhysicalFonts.get(fontNameAsInFontTablePart);
        return pfRegular != null ? pfRegular : this.regularForms.get(fontNameAsInFontTablePart);
    }

    public PhysicalFont getBoldForm(String fontNameAsInFontTablePart, PhysicalFont pf) {
        if (pf == null) {
            return this.boldForms.get(fontNameAsInFontTablePart);
        }
        PhysicalFont pfBold = PhysicalFonts.getBoldForm(pf);
        return pfBold != null ? pfBold : this.boldForms.get(fontNameAsInFontTablePart);
    }

    public PhysicalFont getItalicForm(String fontNameAsInFontTablePart, PhysicalFont pf) {
        if (pf == null) {
            return this.italicForms.get(fontNameAsInFontTablePart);
        }
        PhysicalFont pfItalic = PhysicalFonts.getItalicForm(pf);
        return pfItalic != null ? pfItalic : this.italicForms.get(fontNameAsInFontTablePart);
    }

    public PhysicalFont getBoldItalicForm(String fontNameAsInFontTablePart, PhysicalFont pf) {
        if (pf == null) {
            return this.boldItalicForms.get(fontNameAsInFontTablePart);
        }
        PhysicalFont pfBoldItalic = PhysicalFonts.getBoldItalicForm(pf);
        return pfBoldItalic != null ? pfBoldItalic : this.boldItalicForms.get(fontNameAsInFontTablePart);
    }
}

