/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.complexscripts.util;

import java.util.HashMap;
import java.util.Map;

public class CharAssociation
implements Cloneable {
    private final int offset;
    private final int count;
    private final int[] subIntervals;
    private Map<String, Object> predications;
    private static volatile Map<String, PredicationMerger> predicationMergers;
    private static final int[] SORT_INCREMENTS_16;
    private static final int[] SORT_INCREMENTS_03;

    public CharAssociation(int offset, int count, int[] subIntervals) {
        this.offset = offset;
        this.count = count;
        this.subIntervals = subIntervals != null && subIntervals.length > 2 ? subIntervals : null;
    }

    public CharAssociation(int offset, int count) {
        this(offset, count, null);
    }

    public CharAssociation(int[] subIntervals) {
        this(CharAssociation.getSubIntervalsStart(subIntervals), CharAssociation.getSubIntervalsLength(subIntervals), subIntervals);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    public int getStart() {
        return this.getOffset();
    }

    public int getEnd() {
        return this.getOffset() + this.getCount();
    }

    public boolean isDisjoint() {
        return this.subIntervals != null;
    }

    public int[] getSubIntervals() {
        return this.subIntervals;
    }

    public int getSubIntervalCount() {
        return this.subIntervals != null ? this.subIntervals.length / 2 : 0;
    }

    public boolean contained(int offset, int count) {
        int s2 = offset;
        int e = offset + count;
        if (!this.isDisjoint()) {
            int s0 = this.getStart();
            int e0 = this.getEnd();
            return s0 >= s2 && e0 <= e;
        }
        int ns = this.getSubIntervalCount();
        for (int i = 0; i < ns; ++i) {
            int s0 = this.subIntervals[2 * i + 0];
            int e0 = this.subIntervals[2 * i + 1];
            if (s0 < s2 || e0 > e) continue;
            return true;
        }
        return false;
    }

    public void setPredication(String key, Object value) {
        if (this.predications == null) {
            this.predications = new HashMap<String, Object>();
        }
        if (this.predications != null) {
            this.predications.put(key, value);
        }
    }

    public Object getPredication(String key) {
        if (this.predications != null) {
            return this.predications.get(key);
        }
        return null;
    }

    public void mergePredication(String key, Object value) {
        if (this.predications == null) {
            this.predications = new HashMap<String, Object>();
        }
        if (this.predications != null) {
            if (this.predications.containsKey(key)) {
                Object v1 = this.predications.get(key);
                Object v2 = value;
                this.predications.put(key, CharAssociation.mergePredicationValues(key, v1, v2));
            } else {
                this.predications.put(key, value);
            }
        }
    }

    public static Object mergePredicationValues(String key, Object v1, Object v2) {
        PredicationMerger pm = CharAssociation.getPredicationMerger(key);
        if (pm != null) {
            return pm.merge(key, v1, v2);
        }
        if (v2 != null) {
            return v2;
        }
        return v1;
    }

    public void mergePredications(CharAssociation ca) {
        if (ca.predications != null) {
            for (Map.Entry<String, Object> e : ca.predications.entrySet()) {
                this.mergePredication(e.getKey(), e.getValue());
            }
        }
    }

    public Object clone() {
        try {
            CharAssociation ca = (CharAssociation)super.clone();
            if (this.predications != null) {
                ca.predications = new HashMap<String, Object>(this.predications);
            }
            return ca;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static void setPredicationMerger(String key, PredicationMerger pm) {
        if (predicationMergers == null) {
            predicationMergers = new HashMap<String, PredicationMerger>();
        }
        if (predicationMergers != null) {
            predicationMergers.put(key, pm);
        }
    }

    public static PredicationMerger getPredicationMerger(String key) {
        if (predicationMergers != null) {
            return predicationMergers.get(key);
        }
        return null;
    }

    public static CharAssociation[] replicate(CharAssociation a, int repeat) {
        CharAssociation[] aa = new CharAssociation[repeat];
        int n = aa.length;
        for (int i = 0; i < n; ++i) {
            aa[i] = (CharAssociation)a.clone();
        }
        return aa;
    }

    public static CharAssociation join(CharAssociation[] aa) {
        CharAssociation ca;
        int[] ia = CharAssociation.extractIntervals(aa);
        if (ia == null || ia.length == 0) {
            ca = new CharAssociation(0, 0);
        } else if (ia.length == 2) {
            int s2 = ia[0];
            int e = ia[1];
            ca = new CharAssociation(s2, e - s2);
        } else {
            ca = new CharAssociation(CharAssociation.mergeIntervals(ia));
        }
        return CharAssociation.mergePredicates(ca, aa);
    }

    private static CharAssociation mergePredicates(CharAssociation ca, CharAssociation[] aa) {
        for (CharAssociation a : aa) {
            ca.mergePredications(a);
        }
        return ca;
    }

    private static int getSubIntervalsStart(int[] ia) {
        int us = Integer.MAX_VALUE;
        int ue = Integer.MIN_VALUE;
        if (ia != null) {
            int n = ia.length;
            for (int i = 0; i < n; i += 2) {
                int s2 = ia[i + 0];
                int e = ia[i + 1];
                if (s2 < us) {
                    us = s2;
                }
                if (e <= ue) continue;
                ue = e;
            }
            if (ue < 0) {
                ue = 0;
            }
            if (us > ue) {
                us = ue;
            }
        }
        return us;
    }

    private static int getSubIntervalsLength(int[] ia) {
        int us = Integer.MAX_VALUE;
        int ue = Integer.MIN_VALUE;
        if (ia != null) {
            int n = ia.length;
            for (int i = 0; i < n; i += 2) {
                int s2 = ia[i + 0];
                int e = ia[i + 1];
                if (s2 < us) {
                    us = s2;
                }
                if (e <= ue) continue;
                ue = e;
            }
            if (ue < 0) {
                ue = 0;
            }
            if (us > ue) {
                us = ue;
            }
        }
        return ue - us;
    }

    private static int[] extractIntervals(CharAssociation[] aa) {
        int ni = 0;
        for (CharAssociation a : aa) {
            if (a.isDisjoint()) {
                ni += a.getSubIntervalCount();
                continue;
            }
            ++ni;
        }
        int[] sa = new int[ni];
        int[] ea = new int[ni];
        int k = 0;
        for (int i = 0; i < aa.length; ++i) {
            CharAssociation a = aa[i];
            if (a.isDisjoint()) {
                int[] da = a.getSubIntervals();
                for (int j = 0; j < da.length; j += 2) {
                    sa[k] = da[j + 0];
                    ea[k] = da[j + 1];
                    ++k;
                }
                continue;
            }
            sa[k] = a.getStart();
            ea[k] = a.getEnd();
            ++k;
        }
        return CharAssociation.sortIntervals(sa, ea);
    }

    private static int[] sortIntervals(int[] sa, int[] ea) {
        int[] incr;
        assert (sa != null);
        assert (ea != null);
        assert (sa.length == ea.length);
        int ni = sa.length;
        int[] nArray = incr = ni < 21 ? SORT_INCREMENTS_03 : SORT_INCREMENTS_16;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int anIncr;
            int h2;
            int n2 = ni;
            for (int i2 = h2 = (anIncr = nArray[i]); i2 < n2; ++i2) {
                int s1 = sa[i2];
                int e1 = ea[i2];
                for (int j = i2; j >= h2; j -= h2) {
                    int s2 = sa[j - h2];
                    int e2 = ea[j - h2];
                    if (s2 > s1) {
                        sa[j] = s2;
                        ea[j] = e2;
                        continue;
                    }
                    if (s2 != s1 || e2 <= e1) break;
                    sa[j] = s2;
                    ea[j] = e2;
                }
                sa[j] = s1;
                ea[j] = e1;
            }
        }
        int[] ia = new int[ni * 2];
        for (int i = 0; i < ni; ++i) {
            ia[i * 2 + 0] = sa[i];
            ia[i * 2 + 1] = ea[i];
        }
        return ia;
    }

    private static int[] mergeIntervals(int[] ia) {
        int i;
        int ni = ia.length;
        int n = ni;
        int nm = 0;
        int ie = -1;
        int is = -1;
        for (i = 0; i < n; i += 2) {
            int s2 = ia[i + 0];
            int e = ia[i + 1];
            if (ie < 0 || s2 > ie) {
                is = s2;
                ie = e;
                ++nm;
                continue;
            }
            if (s2 < is || e <= ie) continue;
            ie = e;
        }
        int[] mi = new int[nm * 2];
        n = ni;
        nm = 0;
        ie = -1;
        is = -1;
        for (i = 0; i < n; i += 2) {
            int s3 = ia[i + 0];
            int e = ia[i + 1];
            int k = nm * 2;
            if (ie < 0 || s3 > ie) {
                is = s3;
                ie = e;
                mi[k + 0] = is;
                mi[k + 1] = ie;
                ++nm;
                continue;
            }
            if (s3 < is) continue;
            if (e > ie) {
                ie = e;
            }
            mi[k - 1] = ie;
        }
        return mi;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(this.offset);
        sb.append(',');
        sb.append(this.count);
        sb.append(']');
        return sb.toString();
    }

    static {
        SORT_INCREMENTS_16 = new int[]{1391376, 463792, 198768, 86961, 33936, 13776, 4592, 1968, 861, 336, 112, 48, 21, 7, 3, 1};
        SORT_INCREMENTS_03 = new int[]{7, 3, 1};
    }

    static interface PredicationMerger {
        public Object merge(String var1, Object var2, Object var3);
    }
}

