/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.util.JAXBResult;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class OpenDoPEIntegrity {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEIntegrity.class);
    private HashMap<String, String> commentRangeStart;
    private HashMap<String, String> commentRangeEnd;
    private HashMap<String, String> commentReference;
    private HashMap<String, String> footnoteReference;
    private HashMap<String, String> endnoteReference;
    static Templates xslt;

    public static void log(String message) {
        log.info(message);
    }

    public void process(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.commentRangeStart = new HashMap();
        this.commentRangeEnd = new HashMap();
        this.commentReference = new HashMap();
        this.footnoteReference = new HashMap();
        this.endnoteReference = new HashMap();
        this.process(wordMLPackage.getMainDocumentPart());
        RelationshipsPart rp = wordMLPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.process((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.process((FooterPart)rp.getPart(r));
        }
    }

    private void process(JaxbXmlPart part) throws Docx4JException {
        block5: {
            log.info("/n Processing " + part.getPartName().getName());
            OpcPackage pkg = part.getPackage();
            Document doc = XmlUtils.marshaltoW3CDomDocument(part.getJaxbElement());
            JAXBContext jc = Context.jc;
            try {
                Unmarshaller u = jc.createUnmarshaller();
                JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
                u.setEventHandler(eventHandler);
                HashMap<String, Object> transformParameters = new HashMap<String, Object>();
                transformParameters.put("OpenDoPEIntegrity", this);
                try {
                    JAXBResult result = new JAXBResult(u);
                    XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
                    part.setJaxbElement(result);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    log.error("Input in question:" + XmlUtils.w3CDomNodeToString(doc));
                    log.error("Now trying DOMResult..");
                    DOMResult result = new DOMResult();
                    XmlUtils.transform(doc, xslt, transformParameters, (Result)result);
                    if (log.isDebugEnabled()) {
                        Document docResult = (Document)result.getNode();
                        Object o = XmlUtils.unmarshal((Document)result.getNode());
                        part.setJaxbElement(o);
                        break block5;
                    }
                    Object o = XmlUtils.unmarshal((Document)result.getNode());
                    part.setJaxbElement(o);
                }
            }
            catch (Exception e) {
                throw new Docx4JException("Problems ensuring integrity", e);
            }
        }
    }

    public static boolean encountered(OpenDoPEIntegrity odIntegrityInstance, String elementName, String id) {
        boolean previouslyEncountered = false;
        if (elementName.equals("commentRangeStart")) {
            previouslyEncountered = odIntegrityInstance.commentRangeStart.containsKey(id);
            if (!previouslyEncountered) {
                odIntegrityInstance.commentRangeStart.put(id, id);
            }
            return previouslyEncountered;
        }
        if (elementName.equals("commentRangeEnd")) {
            previouslyEncountered = odIntegrityInstance.commentRangeEnd.containsKey(id);
            if (!previouslyEncountered) {
                odIntegrityInstance.commentRangeEnd.put(id, id);
            }
            return previouslyEncountered;
        }
        if (elementName.equals("commentReference")) {
            previouslyEncountered = odIntegrityInstance.commentReference.containsKey(id);
            if (!previouslyEncountered) {
                odIntegrityInstance.commentReference.put(id, id);
            }
            return previouslyEncountered;
        }
        if (elementName.equals("footnoteReference")) {
            previouslyEncountered = odIntegrityInstance.footnoteReference.containsKey(id);
            if (!previouslyEncountered) {
                odIntegrityInstance.footnoteReference.put(id, id);
            }
            return previouslyEncountered;
        }
        if (elementName.equals("endnoteReference")) {
            previouslyEncountered = odIntegrityInstance.endnoteReference.containsKey(id);
            if (!previouslyEncountered) {
                odIntegrityInstance.endnoteReference.put(id, id);
            }
            return previouslyEncountered;
        }
        log.error("Unexpected elementName: " + elementName);
        return false;
    }

    static {
        try {
            StreamSource xsltSource = new StreamSource(ResourceUtils.getResource("org/docx4j/model/datastorage/OpenDoPEIntegrity.xslt"));
            xslt = XmlUtils.getTransformerTemplate(xsltSource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
    }
}

