/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3.stores;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.CRC32;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.Docx4JRuntimeException;
import org.docx4j.openpackaging.exceptions.PartTooLargeException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EmbeddedPackagePart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ZipPartStore
implements PartStore {
    private static Logger log = LoggerFactory.getLogger(ZipPartStore.class);
    HashMap<String, ByteArray> partByteArrays;
    long MAX_BYTES_Unzip_Error = -1L;
    private PartStore sourcePartStore;
    private ZipArchiveOutputStream zos;

    private void initMaxBytes() {
        this.MAX_BYTES_Unzip_Error = Docx4jProperties.getPropertyLong("docx4j.openpackaging.parts.MAX_BYTES.unzip.error", -1L);
    }

    public ZipPartStore() {
        this.initMaxBytes();
    }

    public ZipPartStore(File f) throws Docx4JException {
        this.initMaxBytes();
        log.info("Filepath = " + f.getPath());
        ZipFile zf = null;
        try {
            if (!f.exists()) {
                log.info("Couldn't find " + f.getPath());
            }
            zf = new ZipFile(f);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new Docx4JException("Couldn't get ZipFile", ioe);
        }
        this.partByteArrays = new HashMap();
        Enumeration<ZipArchiveEntry> entries = zf.getEntries();
        while (entries.hasMoreElements()) {
            ZipArchiveEntry entry = entries.nextElement();
            this.policePartSize(f, entry.getSize(), entry.getName());
            Object in = null;
            try {
                byte[] bytes = this.getBytesFromInputStream(zf.getInputStream(entry), entry.getSize());
                this.policePartSize(f, bytes.length, entry.getName());
                this.partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            catch (PartTooLargeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Docx4JException("Error processing zip file (is it a zip file?)", e);
            }
        }
        try {
            zf.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    private void policePartSize(File f, long length, String entryName) throws PartTooLargeException {
        if (this.MAX_BYTES_Unzip_Error > -1L && length > this.MAX_BYTES_Unzip_Error) {
            if (f == null) {
                throw new PartTooLargeException(entryName + ", length " + length + " exceeds your configured maximum allowed size for unzip.");
            }
            throw new PartTooLargeException(f.getName() + ", " + entryName + ", length " + length + " exceeds your configured maximum allowed size for unzip.");
        }
    }

    public ZipPartStore(InputStream is) throws Docx4JException {
        this.initMaxBytes();
        this.partByteArrays = new HashMap();
        try {
            ZipArchiveInputStream zis = new ZipArchiveInputStream(is);
            ArchiveEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                this.policePartSize(null, entry.getSize(), entry.getName());
                byte[] bytes = this.getBytesFromInputStream(zis, entry.getSize());
                this.policePartSize(null, bytes.length, entry.getName());
                this.partByteArrays.put(entry.getName(), new ByteArray(bytes));
            }
            zis.close();
        }
        catch (PartTooLargeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Docx4JException("Error processing zip file (is it a zip file?)", e);
        }
    }

    @Override
    public void setSourcePartStore(PartStore partStore) {
        this.sourcePartStore = partStore;
    }

    public boolean partExists(String partName) {
        return this.partByteArrays.get(partName) != null;
    }

    private byte[] getBytesFromInputStream(InputStream is, long size) throws Exception {
        if (size == -1L) {
            log.debug("entry.getSize() -1");
            return is.readAllBytes();
        }
        log.debug("entry.getSize()={}", (Object)size);
        return is.readNBytes(Math.toIntExact(size));
    }

    @Override
    public InputStream loadPart(String partName) throws Docx4JException {
        ByteArray bytes = this.partByteArrays.get(partName);
        if (bytes == null) {
            if (partName.endsWith(".rels")) {
                log.debug("part '" + partName + "' not present in part store");
            } else {
                log.warn("part '" + partName + "' not present in part store");
            }
            return null;
        }
        return bytes.getInputStream();
    }

    @Override
    public long getPartSize(String partName) throws Docx4JException {
        ByteArray bytes = this.partByteArrays.get(partName);
        if (bytes == null) {
            return -1L;
        }
        return bytes.getLength();
    }

    public ByteArray getByteArray(String partName) throws Docx4JException {
        return this.partByteArrays.get(partName);
    }

    @Override
    public void rename(PartName oldName, PartName newName) {
        log.info("Renaming part " + oldName.getName() + " to " + newName.getName());
        ByteArray partByteArray = this.partByteArrays.remove(oldName.getName().substring(1));
        if (partByteArray == null) {
            throw new Docx4JRuntimeException(oldName.getName().substring(1) + " not present in store");
        }
        this.partByteArrays.put(newName.getName().substring(1), partByteArray);
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.zos = new ZipArchiveOutputStream(os);
    }

    @Override
    public void saveContentTypes(ContentTypeManager ctm) throws Docx4JException {
        try {
            this.zos.putArchiveEntry(new ZipArchiveEntry("[Content_Types].xml"));
            ctm.marshal(this.zos);
            this.zos.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling Content_Types ", e);
        }
    }

    @Override
    public void saveJaxbXmlPart(JaxbXmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().equals("_rels/.rels") ? part.getPartName().getName() : part.getPartName().getName().substring(1);
        try {
            this.zos.putArchiveEntry(new ZipArchiveEntry(targetName));
            if (part.isUnmarshalled()) {
                log.debug("marshalling " + part.getPartName());
                part.marshal(this.zos);
            } else {
                if (this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                if (this.sourcePartStore == this) {
                    log.debug(part.getPartName() + " is clean");
                    ByteArray bytes = this.partByteArrays.get(part.getPartName().getName().substring(1));
                    if (bytes == null) {
                        throw new IOException("part '" + part.getPartName() + "' not found");
                    }
                    this.zos.write(bytes.getBytes());
                } else {
                    InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                    int read = 0;
                    byte[] bytes = new byte[1024];
                    while ((read = is.read(bytes)) != -1) {
                        this.zos.write(bytes, 0, read);
                    }
                    is.close();
                }
            }
            this.zos.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling JaxbXmlPart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveCustomXmlDataStoragePart(CustomXmlDataStoragePart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        try {
            this.zos.putArchiveEntry(new ZipArchiveEntry(targetName));
            part.getData().writeDocument(this.zos);
            this.zos.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling CustomXmlDataStoragePart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveXmlPart(XmlPart part) throws Docx4JException {
        String targetName = part.getPartName().getName().substring(1);
        try {
            this.zos.putArchiveEntry(new ZipArchiveEntry(targetName));
            Document doc = part.getDocument();
            DOMSource source = new DOMSource(doc);
            XmlUtils.getTransformerFactory().newTransformer().transform(source, new StreamResult(this.zos));
            this.zos.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Error marshalling XmlPart " + part.getPartName(), e);
        }
    }

    @Override
    public void saveBinaryPart(Part part) throws Docx4JException {
        if (log.isDebugEnabled()) {
            log.debug("saving " + part.getPartName() + " class " + part.getClass().getName());
        }
        String resolvedPartUri = part.getPartName().getName().substring(1);
        try {
            byte[] bytes = null;
            if (((BinaryPart)part).isLoaded()) {
                bytes = ((BinaryPart)part).getBytes();
            } else {
                if (this.sourcePartStore == null) {
                    throw new Docx4JException("part store has changed, and sourcePartStore not set");
                }
                if (this.sourcePartStore == this) {
                    log.debug(part.getPartName() + " is clean");
                    ByteArray byteArray = this.partByteArrays.get(part.getPartName().getName().substring(1));
                    if (byteArray == null) {
                        throw new IOException("part '" + part.getPartName() + "' contents not found");
                    }
                    bytes = byteArray.getBytes();
                } else {
                    InputStream is = this.sourcePartStore.loadPart(part.getPartName().getName().substring(1));
                    bytes = IOUtils.toByteArray(is);
                }
            }
            if (part instanceof OleObjectBinaryPart || !ZipPartStore.shouldCompress(part)) {
                ZipArchiveEntry ze = new ZipArchiveEntry(resolvedPartUri);
                ze.setMethod(0);
                ze.setSize(bytes.length);
                ze.setCompressedSize(bytes.length);
                CRC32 crc = new CRC32();
                crc.update(bytes);
                ze.setCrc(crc.getValue());
                this.zos.putArchiveEntry(ze);
            } else {
                this.zos.putArchiveEntry(new ZipArchiveEntry(resolvedPartUri));
            }
            this.zos.write(bytes);
            this.zos.closeArchiveEntry();
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
        log.debug("success writing part: " + resolvedPartUri);
    }

    private static boolean shouldCompress(Part part) {
        if (part instanceof EmbeddedPackagePart || part instanceof ImagePngPart || part instanceof ImageJpegPart || part instanceof ImageGifPart) {
            return false;
        }
        if (part instanceof AlternativeFormatInputPart) {
            AltChunkType type = ((AlternativeFormatInputPart)part).getAltChunkType();
            return type != AltChunkType.WordprocessingML && type != AltChunkType.OfficeWordTemplate && type != AltChunkType.OfficeWordMacroEnabled && type != AltChunkType.OfficeWordMacroEnabledTemplate;
        }
        return true;
    }

    @Override
    public void finishSave() throws Docx4JException {
        try {
            this.zos.close();
        }
        catch (Exception e) {
            throw new Docx4JException("Failed to put binary part", e);
        }
    }

    @Override
    public void dispose() {
    }

    public static class ByteArray
    implements Serializable {
        private static final long serialVersionUID = -784146312250361899L;
        private byte[] bytes;
        private String mimetype;

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public String getMimetype() {
            return this.mimetype;
        }

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public ByteArray(ByteBuffer bb, String mimetype) {
            bb.rewind();
            this.bytes = new byte[bb.limit()];
            bb.get(this.bytes, 0, this.bytes.length);
            this.mimetype = mimetype;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        public int getLength() {
            return this.bytes.length;
        }
    }
}

