/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.complexscripts.fonts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.docx4j.fonts.fop.complexscripts.fonts.AdvancedTypographicTableFormatException;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphCoverageTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphPositioningState;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphPositioningSubtable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphSubstitutionState;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphSubstitutionSubtable;
import org.docx4j.fonts.fop.complexscripts.fonts.GlyphSubtable;
import org.docx4j.fonts.fop.complexscripts.fonts.OTFScript;
import org.docx4j.fonts.fop.complexscripts.scripts.ScriptProcessor;
import org.docx4j.fonts.fop.complexscripts.util.GlyphSequence;
import org.docx4j.fonts.fop.complexscripts.util.ScriptContextTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlyphTable {
    private static final Logger log = LoggerFactory.getLogger(GlyphTable.class);
    public static final int GLYPH_TABLE_TYPE_SUBSTITUTION = 1;
    public static final int GLYPH_TABLE_TYPE_POSITIONING = 2;
    public static final int GLYPH_TABLE_TYPE_JUSTIFICATION = 3;
    public static final int GLYPH_TABLE_TYPE_BASELINE = 4;
    public static final int GLYPH_TABLE_TYPE_DEFINITION = 5;
    private GlyphTable gdef;
    private Map<LookupSpec, List<String>> lookups;
    private Map<String, LookupTable> lookupTables;
    private Map<LookupSpec, Map<LookupSpec, List<LookupTable>>> matchedLookups;
    private boolean frozen;
    protected Map<String, ScriptProcessor> processors;

    public GlyphTable(GlyphTable gdef, Map<LookupSpec, List<String>> lookups, Map<String, ScriptProcessor> processors) {
        this.processors = processors;
        if (gdef != null && !(gdef instanceof GlyphDefinitionTable)) {
            throw new AdvancedTypographicTableFormatException("bad glyph definition table");
        }
        if (lookups == null) {
            throw new AdvancedTypographicTableFormatException("lookups must be non-null map");
        }
        this.gdef = gdef;
        this.lookups = lookups;
        this.lookupTables = new LinkedHashMap<String, LookupTable>();
        this.matchedLookups = new HashMap<LookupSpec, Map<LookupSpec, List<LookupTable>>>();
    }

    public GlyphDefinitionTable getGlyphDefinitions() {
        return (GlyphDefinitionTable)this.gdef;
    }

    public List<LookupSpec> getLookups() {
        return this.matchLookupSpecs("*", "*", "*");
    }

    public List<LookupTable> getLookupTables() {
        TreeSet<String> lids = new TreeSet<String>(this.lookupTables.keySet());
        ArrayList<LookupTable> ltl = new ArrayList<LookupTable>(lids.size());
        Iterator<String> iterator = lids.iterator();
        while (iterator.hasNext()) {
            String lid1;
            String lid = lid1 = iterator.next();
            ltl.add(this.lookupTables.get(lid));
        }
        return ltl;
    }

    public LookupTable getLookupTable(String lid) {
        return this.lookupTables.get(lid);
    }

    protected void addSubtable(GlyphSubtable subtable) {
        if (this.frozen) {
            throw new IllegalStateException("glyph table is frozen, subtable addition prohibited");
        }
        subtable.setTable(this);
        String lid = subtable.getLookupId();
        if (this.lookupTables.containsKey(lid)) {
            LookupTable lt = this.lookupTables.get(lid);
            lt.addSubtable(subtable);
        } else {
            LookupTable lt = new LookupTable(lid, subtable);
            this.lookupTables.put(lid, lt);
        }
    }

    protected void freezeSubtables() {
        if (!this.frozen) {
            Iterator<LookupTable> iterator = this.lookupTables.values().iterator();
            while (iterator.hasNext()) {
                LookupTable o;
                LookupTable lt = o = iterator.next();
                lt.freezeSubtables(this.lookupTables);
            }
            this.frozen = true;
        }
    }

    public List<LookupSpec> matchLookupSpecs(String script, String language, String feature) {
        Set<LookupSpec> keys = this.lookups.keySet();
        ArrayList<LookupSpec> matches = new ArrayList<LookupSpec>();
        Iterator<LookupSpec> iterator = keys.iterator();
        while (iterator.hasNext()) {
            LookupSpec key;
            LookupSpec ls = key = iterator.next();
            if (!"*".equals(script) && !ls.getScript().equals(script) || !"*".equals(language) && !ls.getLanguage().equals(language) || !"*".equals(feature) && !ls.getFeature().equals(feature)) continue;
            matches.add(ls);
        }
        return matches;
    }

    public Map<LookupSpec, List<LookupTable>> matchLookups(String script, String language, String feature) {
        LookupSpec lsm = new LookupSpec(script, language, feature, true, true);
        Map<LookupSpec, List<LookupTable>> lm = this.matchedLookups.get(lsm);
        if (lm == null) {
            lm = new LinkedHashMap<LookupSpec, List<LookupTable>>();
            List<LookupSpec> lsl = this.matchLookupSpecs(script, language, feature);
            Iterator<LookupSpec> iterator = lsl.iterator();
            while (iterator.hasNext()) {
                LookupSpec aLsl;
                LookupSpec ls = aLsl = iterator.next();
                lm.put(ls, this.findLookupTables(ls));
            }
            this.matchedLookups.put(lsm, lm);
        }
        if (lm.isEmpty() && !OTFScript.isDefault(script) && !OTFScript.isWildCard(script)) {
            return this.matchLookups("DFLT", "dflt", feature);
        }
        return lm;
    }

    public List<LookupTable> findLookupTables(LookupSpec ls) {
        TreeSet<LookupTable> lts = new TreeSet<LookupTable>();
        List<String> ids = this.lookups.get(ls);
        if (ids != null) {
            for (String id : ids) {
                String lid = id;
                LookupTable lt = this.lookupTables.get(lid);
                if (lt == null) continue;
                lts.add(lt);
            }
        }
        return new ArrayList<LookupTable>(lts);
    }

    public UseSpec[] assembleLookups(String[] features, Map<LookupSpec, List<LookupTable>> lookups) {
        TreeSet<UseSpec> uss = new TreeSet<UseSpec>();
        for (String feature : features) {
            for (Map.Entry<LookupSpec, List<LookupTable>> o : lookups.entrySet()) {
                List<LookupTable> ltl;
                Map.Entry<LookupSpec, List<LookupTable>> e = o;
                LookupSpec ls = e.getKey();
                if (!ls.getFeature().equals(feature) || (ltl = e.getValue()) == null) continue;
                Iterator<LookupTable> iterator = ltl.iterator();
                while (iterator.hasNext()) {
                    LookupTable aLtl;
                    LookupTable lt = aLtl = iterator.next();
                    uss.add(new UseSpec(lt, feature));
                }
            }
        }
        return uss.toArray(new UseSpec[uss.size()]);
    }

    public boolean hasFeature(String script, String language, String feature) {
        UseSpec[] usa = this.assembleLookups(new String[]{feature}, this.matchLookups(script, language, feature));
        return usa.length > 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("{");
        sb.append("lookups={");
        sb.append(this.lookups.toString());
        sb.append("},lookupTables={");
        sb.append(this.lookupTables.toString());
        sb.append("}}");
        return sb.toString();
    }

    public static int getTableTypeFromName(String name) {
        String s2 = name.toLowerCase();
        int t = "gsub".equals(s2) ? 1 : ("gpos".equals(s2) ? 2 : ("jstf".equals(s2) ? 3 : ("base".equals(s2) ? 4 : ("gdef".equals(s2) ? 5 : -1))));
        return t;
    }

    public static void resolveLookupReferences(RuleSet[] rsa, Map<String, LookupTable> lookupTables) {
        if (rsa != null && lookupTables != null) {
            for (RuleSet rs : rsa) {
                if (rs == null) continue;
                rs.resolveLookupReferences(lookupTables);
            }
        }
    }

    public static class LookupTable
    implements Comparable {
        private final String id;
        private final int idOrdinal;
        private final List<GlyphSubtable> subtables;
        private boolean doesSub;
        private boolean doesPos;
        private boolean frozen;
        private GlyphSubtable[] subtablesArray;
        private static GlyphSubtable[] subtablesArrayEmpty = new GlyphSubtable[0];

        public LookupTable(String id, GlyphSubtable subtable) {
            this(id, LookupTable.makeSingleton(subtable));
        }

        public LookupTable(String id, List<GlyphSubtable> subtables) {
            assert (id != null);
            assert (id.length() != 0);
            assert (id.startsWith("lu"));
            this.id = id;
            this.idOrdinal = Integer.parseInt(id.substring(2));
            this.subtables = new LinkedList<GlyphSubtable>();
            if (subtables != null) {
                Iterator<GlyphSubtable> iterator = subtables.iterator();
                while (iterator.hasNext()) {
                    GlyphSubtable subtable;
                    GlyphSubtable st = subtable = iterator.next();
                    this.addSubtable(st);
                }
            }
        }

        public GlyphSubtable[] getSubtables() {
            if (this.frozen) {
                return this.subtablesArray != null ? this.subtablesArray : subtablesArrayEmpty;
            }
            if (this.doesSub) {
                return this.subtables.toArray(new GlyphSubstitutionSubtable[this.subtables.size()]);
            }
            if (this.doesPos) {
                return this.subtables.toArray(new GlyphPositioningSubtable[this.subtables.size()]);
            }
            return null;
        }

        public boolean addSubtable(GlyphSubtable subtable) {
            boolean added = false;
            if (this.frozen) {
                throw new IllegalStateException("glyph table is frozen, subtable addition prohibited");
            }
            this.validateSubtable(subtable);
            ListIterator<GlyphSubtable> lit = this.subtables.listIterator(0);
            while (lit.hasNext()) {
                GlyphSubtable st = lit.next();
                int d = subtable.compareTo(st);
                if (d < 0) {
                    lit.set(subtable);
                    lit.add(st);
                    added = true;
                    continue;
                }
                if (d != 0) continue;
                added = false;
                subtable = null;
            }
            if (!added && subtable != null) {
                this.subtables.add(subtable);
                added = true;
            }
            return added;
        }

        private void validateSubtable(GlyphSubtable subtable) {
            GlyphSubtable st;
            if (subtable == null) {
                throw new AdvancedTypographicTableFormatException("subtable must be non-null");
            }
            if (subtable instanceof GlyphSubstitutionSubtable) {
                if (this.doesPos) {
                    throw new AdvancedTypographicTableFormatException("subtable must be positioning subtable, but is: " + subtable);
                }
                this.doesSub = true;
            }
            if (subtable instanceof GlyphPositioningSubtable) {
                if (this.doesSub) {
                    throw new AdvancedTypographicTableFormatException("subtable must be substitution subtable, but is: " + subtable);
                }
                this.doesPos = true;
            }
            if (this.subtables.size() > 0 && !(st = this.subtables.get(0)).isCompatible(subtable)) {
                throw new AdvancedTypographicTableFormatException("subtable " + subtable + " is not compatible with subtable " + st);
            }
        }

        public void freezeSubtables(Map<String, LookupTable> lookupTables) {
            if (!this.frozen) {
                GlyphSubtable[] sta = this.getSubtables();
                this.resolveLookupReferences(sta, lookupTables);
                this.subtablesArray = sta;
                this.frozen = true;
            }
        }

        private void resolveLookupReferences(GlyphSubtable[] subtables, Map<String, LookupTable> lookupTables) {
            if (subtables != null) {
                for (GlyphSubtable st : subtables) {
                    if (st == null) continue;
                    st.resolveLookupReferences(lookupTables);
                }
            }
        }

        public boolean performsSubstitution() {
            return this.doesSub;
        }

        public GlyphSequence substitute(GlyphSequence gs, String script, String language, String feature, ScriptContextTester sct) {
            if (this.performsSubstitution()) {
                return GlyphSubstitutionSubtable.substitute(gs, script, language, feature, (GlyphSubstitutionSubtable[])this.subtablesArray, sct);
            }
            return gs;
        }

        public GlyphSequence substitute(GlyphSubstitutionState ss, int sequenceIndex) {
            if (this.performsSubstitution()) {
                return GlyphSubstitutionSubtable.substitute(ss, (GlyphSubstitutionSubtable[])this.subtablesArray, sequenceIndex);
            }
            return ss.getInput();
        }

        public boolean performsPositioning() {
            return this.doesPos;
        }

        public boolean position(GlyphSequence gs, String script, String language, String feature, int fontSize, int[] widths, int[][] adjustments, ScriptContextTester sct) {
            if (this.performsPositioning()) {
                return GlyphPositioningSubtable.position(gs, script, language, feature, fontSize, (GlyphPositioningSubtable[])this.subtablesArray, widths, adjustments, sct);
            }
            return false;
        }

        public boolean position(GlyphPositioningState ps, int sequenceIndex) {
            if (this.performsPositioning()) {
                return GlyphPositioningSubtable.position(ps, (GlyphPositioningSubtable[])this.subtablesArray, sequenceIndex);
            }
            return false;
        }

        public int hashCode() {
            return this.idOrdinal;
        }

        public boolean equals(Object o) {
            if (o instanceof LookupTable) {
                LookupTable lt = (LookupTable)o;
                return this.idOrdinal == lt.idOrdinal;
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof LookupTable) {
                LookupTable lt = (LookupTable)o;
                int i = this.idOrdinal;
                int j = lt.idOrdinal;
                if (i < j) {
                    return -1;
                }
                if (i > j) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("id = " + this.id);
            sb.append(", subtables = " + this.subtables);
            sb.append(" }");
            return sb.toString();
        }

        private static List<GlyphSubtable> makeSingleton(GlyphSubtable subtable) {
            if (subtable == null) {
                return null;
            }
            ArrayList<GlyphSubtable> stl = new ArrayList<GlyphSubtable>(1);
            stl.add(subtable);
            return stl;
        }
    }

    public static class LookupSpec
    implements Comparable {
        private final String script;
        private final String language;
        private final String feature;

        public LookupSpec(String script, String language, String feature) {
            this(script, language, feature, false, false);
        }

        LookupSpec(String script, String language, String feature, boolean permitEmpty, boolean permitWildcard) {
            if (script == null || !permitEmpty && script.length() == 0) {
                throw new AdvancedTypographicTableFormatException("script must be non-empty string");
            }
            if (language == null || !permitEmpty && language.length() == 0) {
                throw new AdvancedTypographicTableFormatException("language must be non-empty string");
            }
            if (feature == null || !permitEmpty && feature.length() == 0) {
                throw new AdvancedTypographicTableFormatException("feature must be non-empty string");
            }
            if (!permitWildcard && script.equals("*")) {
                throw new AdvancedTypographicTableFormatException("script must not be wildcard");
            }
            if (!permitWildcard && language.equals("*")) {
                throw new AdvancedTypographicTableFormatException("language must not be wildcard");
            }
            if (!permitWildcard && feature.equals("*")) {
                throw new AdvancedTypographicTableFormatException("feature must not be wildcard");
            }
            this.script = script.trim();
            this.language = language.trim();
            this.feature = feature.trim();
        }

        public String getScript() {
            return this.script;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getFeature() {
            return this.feature;
        }

        public int hashCode() {
            int hc = 0;
            hc = 7 * hc + (hc ^ this.script.hashCode());
            hc = 11 * hc + (hc ^ this.language.hashCode());
            hc = 17 * hc + (hc ^ this.feature.hashCode());
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof LookupSpec) {
                LookupSpec l = (LookupSpec)o;
                if (!l.script.equals(this.script)) {
                    return false;
                }
                if (!l.language.equals(this.language)) {
                    return false;
                }
                return l.feature.equals(this.feature);
            }
            return false;
        }

        public int compareTo(Object o) {
            int d;
            if (o instanceof LookupSpec) {
                LookupSpec ls = (LookupSpec)o;
                d = this.script.compareTo(ls.script);
                if (d == 0 && (d = this.language.compareTo(ls.language)) == 0 && (d = this.feature.compareTo(ls.feature)) == 0) {
                    d = 0;
                }
            } else {
                d = -1;
            }
            return d;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(super.toString());
            sb.append("{");
            sb.append("<'" + this.script + "'");
            sb.append(",'" + this.language + "'");
            sb.append(",'" + this.feature + "'");
            sb.append(">}");
            return sb.toString();
        }
    }

    public static class UseSpec
    implements Comparable {
        private final LookupTable lookupTable;
        private final String feature;

        public UseSpec(LookupTable lookupTable, String feature) {
            this.lookupTable = lookupTable;
            this.feature = feature;
        }

        public LookupTable getLookupTable() {
            return this.lookupTable;
        }

        public String getFeature() {
            return this.feature;
        }

        public GlyphSequence substitute(GlyphSequence gs, String script, String language, ScriptContextTester sct) {
            return this.lookupTable.substitute(gs, script, language, this.feature, sct);
        }

        public boolean position(GlyphSequence gs, String script, String language, int fontSize, int[] widths, int[][] adjustments, ScriptContextTester sct) {
            return this.lookupTable.position(gs, script, language, this.feature, fontSize, widths, adjustments, sct);
        }

        public int hashCode() {
            return this.lookupTable.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof UseSpec) {
                UseSpec u = (UseSpec)o;
                return this.lookupTable.equals(u.lookupTable);
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof UseSpec) {
                UseSpec u = (UseSpec)o;
                return this.lookupTable.compareTo(u.lookupTable);
            }
            return -1;
        }
    }

    public static class RuleSet {
        private final Rule[] rules;

        public RuleSet(Rule[] rules) throws AdvancedTypographicTableFormatException {
            if (rules == null) {
                throw new AdvancedTypographicTableFormatException("rules[] is null");
            }
            this.rules = rules;
        }

        public Rule[] getRules() {
            return this.rules;
        }

        public void resolveLookupReferences(Map<String, LookupTable> lookupTables) {
            if (this.rules != null) {
                for (Rule r : this.rules) {
                    if (r == null) continue;
                    r.resolveLookupReferences(lookupTables);
                }
            }
        }

        public String toString() {
            return "{ rules = " + Arrays.toString(this.rules) + " }";
        }
    }

    public static class HomogeneousRuleSet
    extends RuleSet {
        public HomogeneousRuleSet(Rule[] rules) throws AdvancedTypographicTableFormatException {
            super(rules);
            Object r0 = null;
            int n = rules.length;
            for (int i = 1; r0 == null && i < n; ++i) {
                if (rules[i] == null) continue;
                r0 = rules[i];
            }
            if (r0 != null) {
                Class<?> c = r0.getClass();
                int n2 = rules.length;
                for (int i = 1; i < n2; ++i) {
                    Rule r = rules[i];
                    if (r == null || c.isInstance(r)) continue;
                    throw new AdvancedTypographicTableFormatException("rules[" + i + "] is not an instance of " + c.getName());
                }
            }
        }
    }

    public static class ChainedCoverageSequenceRule
    extends CoverageSequenceRule {
        private final GlyphCoverageTable[] backtrackCoverages;
        private final GlyphCoverageTable[] lookaheadCoverages;

        public ChainedCoverageSequenceRule(RuleLookup[] lookups, int inputSequenceLength, GlyphCoverageTable[] coverages, GlyphCoverageTable[] backtrackCoverages, GlyphCoverageTable[] lookaheadCoverages) {
            super(lookups, inputSequenceLength, coverages);
            assert (backtrackCoverages != null);
            assert (lookaheadCoverages != null);
            this.backtrackCoverages = backtrackCoverages;
            this.lookaheadCoverages = lookaheadCoverages;
        }

        public GlyphCoverageTable[] getBacktrackCoverages() {
            return this.backtrackCoverages;
        }

        public GlyphCoverageTable[] getLookaheadCoverages() {
            return this.lookaheadCoverages;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", coverages = " + Arrays.toString(this.getCoverages()));
            sb.append(", backtrackCoverages = " + Arrays.toString(this.backtrackCoverages));
            sb.append(", lookaheadCoverages = " + Arrays.toString(this.lookaheadCoverages));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class ChainedClassSequenceRule
    extends ClassSequenceRule {
        private final int[] backtrackClasses;
        private final int[] lookaheadClasses;

        public ChainedClassSequenceRule(RuleLookup[] lookups, int inputSequenceLength, int[] classes, int[] backtrackClasses, int[] lookaheadClasses) {
            super(lookups, inputSequenceLength, classes);
            assert (backtrackClasses != null);
            assert (lookaheadClasses != null);
            this.backtrackClasses = backtrackClasses;
            this.lookaheadClasses = lookaheadClasses;
        }

        public int[] getBacktrackClasses() {
            return this.backtrackClasses;
        }

        public int[] getLookaheadClasses() {
            return this.lookaheadClasses;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", classes = " + Arrays.toString(this.getClasses()));
            sb.append(", backtrackClasses = " + Arrays.toString(this.backtrackClasses));
            sb.append(", lookaheadClasses = " + Arrays.toString(this.lookaheadClasses));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class ChainedGlyphSequenceRule
    extends GlyphSequenceRule {
        private final int[] backtrackGlyphs;
        private final int[] lookaheadGlyphs;

        public ChainedGlyphSequenceRule(RuleLookup[] lookups, int inputSequenceLength, int[] glyphs, int[] backtrackGlyphs, int[] lookaheadGlyphs) {
            super(lookups, inputSequenceLength, glyphs);
            assert (backtrackGlyphs != null);
            assert (lookaheadGlyphs != null);
            this.backtrackGlyphs = backtrackGlyphs;
            this.lookaheadGlyphs = lookaheadGlyphs;
        }

        public int[] getBacktrackGlyphs() {
            return this.backtrackGlyphs;
        }

        public int[] getLookaheadGlyphs() {
            return this.lookaheadGlyphs;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", glyphs = " + Arrays.toString(this.getGlyphs()));
            sb.append(", backtrackGlyphs = " + Arrays.toString(this.backtrackGlyphs));
            sb.append(", lookaheadGlyphs = " + Arrays.toString(this.lookaheadGlyphs));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class CoverageSequenceRule
    extends Rule {
        private final GlyphCoverageTable[] coverages;

        public CoverageSequenceRule(RuleLookup[] lookups, int inputSequenceLength, GlyphCoverageTable[] coverages) {
            super(lookups, inputSequenceLength);
            assert (coverages != null);
            this.coverages = coverages;
        }

        public GlyphCoverageTable[] getCoverages() {
            return this.coverages;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", coverages = " + Arrays.toString(this.coverages));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class ClassSequenceRule
    extends Rule {
        private final int[] classes;

        public ClassSequenceRule(RuleLookup[] lookups, int inputSequenceLength, int[] classes) {
            super(lookups, inputSequenceLength);
            assert (classes != null);
            this.classes = classes;
        }

        public int[] getClasses() {
            return this.classes;
        }

        public int[] getClasses(int firstClass) {
            int[] ca = new int[this.classes.length + 1];
            ca[0] = firstClass;
            System.arraycopy(this.classes, 0, ca, 1, this.classes.length);
            return ca;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", classes = " + Arrays.toString(this.classes));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class GlyphSequenceRule
    extends Rule {
        private final int[] glyphs;

        public GlyphSequenceRule(RuleLookup[] lookups, int inputSequenceLength, int[] glyphs) {
            super(lookups, inputSequenceLength);
            assert (glyphs != null);
            this.glyphs = glyphs;
        }

        public int[] getGlyphs() {
            return this.glyphs;
        }

        public int[] getGlyphs(int firstGlyph) {
            int[] ga = new int[this.glyphs.length + 1];
            ga[0] = firstGlyph;
            System.arraycopy(this.glyphs, 0, ga, 1, this.glyphs.length);
            return ga;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("{ ");
            sb.append("lookups = " + Arrays.toString(this.getLookups()));
            sb.append(", glyphs = " + Arrays.toString(this.glyphs));
            sb.append(" }");
            return sb.toString();
        }
    }

    public static abstract class Rule {
        private final RuleLookup[] lookups;
        private final int inputSequenceLength;

        protected Rule(RuleLookup[] lookups, int inputSequenceLength) {
            assert (lookups != null);
            this.lookups = lookups;
            this.inputSequenceLength = inputSequenceLength;
        }

        public RuleLookup[] getLookups() {
            return this.lookups;
        }

        public int getInputSequenceLength() {
            return this.inputSequenceLength;
        }

        public void resolveLookupReferences(Map<String, LookupTable> lookupTables) {
            if (this.lookups != null) {
                for (RuleLookup l : this.lookups) {
                    if (l == null) continue;
                    l.resolveLookupReferences(lookupTables);
                }
            }
        }

        public String toString() {
            return "{ lookups = " + Arrays.toString(this.lookups) + ", inputSequenceLength = " + this.inputSequenceLength + " }";
        }
    }

    public static class RuleLookup {
        private final int sequenceIndex;
        private final int lookupIndex;
        private LookupTable lookup;

        public RuleLookup(int sequenceIndex, int lookupIndex) {
            this.sequenceIndex = sequenceIndex;
            this.lookupIndex = lookupIndex;
            this.lookup = null;
        }

        public int getSequenceIndex() {
            return this.sequenceIndex;
        }

        public int getLookupIndex() {
            return this.lookupIndex;
        }

        public LookupTable getLookup() {
            return this.lookup;
        }

        public void resolveLookupReferences(Map<String, LookupTable> lookupTables) {
            if (lookupTables != null) {
                String lid = "lu" + Integer.toString(this.lookupIndex);
                LookupTable lt = lookupTables.get(lid);
                if (lt != null) {
                    this.lookup = lt;
                } else {
                    log.warn("unable to resolve glyph lookup table reference '" + lid + "' amongst lookup tables: " + lookupTables.values());
                }
            }
        }

        public String toString() {
            return "{ sequenceIndex = " + this.sequenceIndex + ", lookupIndex = " + this.lookupIndex + " }";
        }
    }
}

